/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.metrics.segmentation.assignment;

public class MunkresKuhnAlgorithm {
    public final double NO_EDGE_VALUE = Double.MAX_VALUE;
    protected int M;
    protected int N;
    protected double[][] weight;
    protected int[] matchingY;
    protected int[] matchingX;
    protected double[] labelingX;
    protected double[] labelingY;
    protected double[] slack;
    protected int[] slackX;
    protected boolean[] S;
    protected boolean[] T;
    protected int[] previousX;
    protected int[] queue;
    protected int x;
    protected int queueStart;
    protected int queueEnd;

    public int[][] computeAssignments(double[][] costMatrix) {
        this.weight = costMatrix;
        this.M = this.weight.length;
        if (this.M == 0) {
            return new int[][]{new int[0]};
        }
        this.N = this.weight[0].length;
        if (this.M <= 1 && this.N <= 1) {
            return new int[][]{new int[0]};
        }
        this.initialize();
        this.calculate();
        int[][] result = new int[this.matchingY.length][];
        int counter = 0;
        for (int x = 0; x < this.matchingY.length; ++x) {
            if (this.matchingY[x] < 0 || this.weight[x][this.matchingY[x]] == Double.MAX_VALUE) continue;
            result[counter++] = new int[]{x, this.matchingY[x]};
        }
        if (counter < result.length) {
            int[][] newResult = new int[counter][];
            System.arraycopy(result, 0, newResult, 0, counter);
            result = newResult;
        }
        return result;
    }

    public double getTotalWeight() {
        double result = 0.0;
        for (int x = 0; x < this.M; ++x) {
            result += -this.labelingX[x];
        }
        for (int y = 0; y < this.M; ++y) {
            result += -this.labelingY[y];
        }
        return result;
    }

    protected final void initialize() {
        int i;
        this.matchingY = new int[this.M];
        this.matchingX = new int[this.N];
        for (i = 0; i < this.matchingX.length; ++i) {
            this.matchingX[i] = -1;
        }
        for (i = 0; i < this.matchingY.length; ++i) {
            this.matchingY[i] = -1;
        }
        this.labelingX = new double[this.M];
        this.labelingY = new double[this.N];
        for (int x = 0; x < this.M; ++x) {
            this.labelingX[x] = -this.weight[x][0];
            for (int y = 1; y < this.N; ++y) {
                if (!(this.labelingX[x] < -this.weight[x][y])) continue;
                this.labelingX[x] = -this.weight[x][y];
            }
        }
        this.slack = new double[this.N];
        this.slackX = new int[this.N];
        this.S = new boolean[this.M];
        this.T = new boolean[this.N];
        this.previousX = new int[this.N];
        this.queue = new int[this.M + this.N];
    }

    protected final void calculate() {
        for (int matches = 0; matches < this.M && matches < this.N; ++matches) {
            int y;
            int i;
            int x = this.findUnmatchedX();
            for (i = 0; i < this.S.length; ++i) {
                this.S[i] = false;
            }
            for (i = 0; i < this.T.length; ++i) {
                this.T[i] = false;
            }
            this.S[x] = true;
            for (y = 0; y < this.N; ++y) {
                this.slack[y] = this.labelingX[x] + this.labelingY[y] - -this.weight[x][y];
                this.slackX[y] = x;
            }
            this.startBreadthFirstSearch(x);
            while (true) {
                if ((y = this.findY()) >= 0) {
                    this.previousX[y] = this.queue[this.queueStart];
                } else {
                    y = this.updateLabels();
                    if (y < 0) continue;
                }
                if (this.matchingX[y] < 0) break;
                this.extendAlternatingTree(y, this.matchingX[y]);
            }
            this.augmentPath(y);
        }
    }

    protected final int findUnmatchedX() {
        for (int x = 0; x < this.M; ++x) {
            if (this.matchingY[x] >= 0) continue;
            return x;
        }
        return -1;
    }

    protected final void startBreadthFirstSearch(int x) {
        this.queueEnd = 0;
        this.queueStart = 0;
        this.queue[this.queueEnd++] = x;
    }

    protected final int findY() {
        while (this.queueStart < this.queueEnd) {
            int x = this.queue[this.queueStart];
            for (int y = 0; y < this.N; ++y) {
                if (this.T[y] || !this.isTight(x, y)) continue;
                return y;
            }
            ++this.queueStart;
        }
        this.queueEnd = 0;
        this.queueStart = 0;
        return -1;
    }

    protected final boolean isTight(int x, int y) {
        return -this.weight[x][y] == this.labelingX[x] + this.labelingY[y];
    }

    protected final int updateLabels() {
        int y;
        double delta = Double.MAX_VALUE;
        for (y = 0; y < this.N; ++y) {
            if (this.T[y] || !(delta > this.slack[y])) continue;
            delta = this.slack[y];
        }
        for (int x = 0; x < this.M; ++x) {
            if (!this.S[x]) continue;
            int n = x;
            this.labelingX[n] = this.labelingX[n] - delta;
        }
        for (y = 0; y < this.N; ++y) {
            if (this.T[y]) {
                int n = y;
                this.labelingY[n] = this.labelingY[n] + delta;
                continue;
            }
            int n = y;
            this.slack[n] = this.slack[n] - delta;
        }
        for (y = 0; y < this.N; ++y) {
            if (this.T[y] || this.slack[y] != 0.0) continue;
            this.previousX[y] = this.slackX[y];
            if (this.matchingX[y] < 0) {
                return y;
            }
            this.extendAlternatingTree(y, this.matchingX[y]);
        }
        return -1;
    }

    protected final void augmentPath(int y) {
        while (y >= 0) {
            int x = this.previousX[y];
            int nextY = this.matchingY[x];
            this.matchingX[y] = x;
            this.matchingY[x] = y;
            y = nextY;
        }
    }

    protected final void extendAlternatingTree(int y, int z) {
        this.T[y] = true;
        this.S[z] = true;
        this.queue[this.queueEnd++] = z;
        for (int y2 = 0; y2 < this.N; ++y2) {
            if (this.T[y2] || !(this.slack[y2] > this.labelingX[z] + this.labelingY[y2] - -this.weight[z][y2])) continue;
            this.slack[y2] = this.labelingX[z] + this.labelingY[y2] - -this.weight[z][y2];
            this.slackX[y2] = z;
        }
    }

    protected boolean verifySlack() {
        boolean result = true;
        for (int y = 0; y < this.N; ++y) {
            if (this.T[y]) continue;
            double min = Double.MAX_VALUE;
            int minX = -1;
            for (int x = 0; x < this.M; ++x) {
                if (!this.S[x] || !(min > this.labelingX[x] + this.labelingY[y] - -this.weight[x][y])) continue;
                min = this.labelingX[x] + this.labelingY[y] - -this.weight[x][y];
                minX = x;
            }
            if (minX < 0) continue;
            if (Math.abs(this.slack[y] - min) / (Math.abs(this.slack[y]) + 1.0E-7) > 1.0E-5) {
                System.err.println("ERROR: slack[" + y + "] should be " + min + " but is " + this.slack[y]);
                result = false;
            }
            if (this.slackX[y] == minX || this.labelingX[this.slackX[y]] + this.labelingY[y] - -this.weight[this.slackX[y]][y] == this.labelingX[minX] + this.labelingY[y] - -this.weight[minX][y]) continue;
            System.err.println("ERROR: slackX[" + y + "] should be " + minX + " but is " + this.slackX[y]);
            result = false;
        }
        return result;
    }

    protected boolean verifyMatching() {
        boolean result = true;
        for (int x = 0; x < this.M; ++x) {
            if (this.matchingY[x] < 0 || this.matchingX[this.matchingY[x]] == x) continue;
            System.err.println("error: x = " + x + " matches " + this.matchingY[x] + ", which matches " + this.matchingX[this.matchingY[x]]);
            result = false;
        }
        for (int y = 0; y < this.N; ++y) {
            if (this.matchingX[y] < 0 || this.matchingY[this.matchingX[y]] == y) continue;
            System.err.println("error: y = " + y + " matches " + this.matchingX[this.x] + ", which matches " + this.matchingY[this.matchingX[y]]);
            result = false;
        }
        return result;
    }

    protected String equalityGraph() {
        String message = "[";
        for (int x = 0; x < this.M; ++x) {
            for (int y = 0; y < this.N; ++y) {
                if (this.labelingX[x] + this.labelingY[y] != -this.weight[x][y]) continue;
                message = message + " " + x + "-" + y;
            }
        }
        message = message + " ]";
        return message;
    }

    protected String alternatingPath(int y) {
        String result = " ]";
        while (y >= 0) {
            int x = this.previousX[y];
            int nextY = this.matchingY[x];
            result = " " + x + "-" + y + result;
            y = nextY;
        }
        return "[" + result;
    }
}

