/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.control.mcu;

import java.util.function.IntConsumer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.janelia.saalfeldlab.control.ButtonControl;
import org.janelia.saalfeldlab.control.mcu.MCUControl;

public class MCUButtonControl
extends MCUControl
implements ButtonControl {
    private static final int STATUS = 144;
    private final int led;
    private boolean isSwitch = false;
    private final Receiver rec;
    private final ShortMessage ledMsg = new ShortMessage();

    public MCUButtonControl(int led, Receiver rec) {
        this.led = led;
        this.rec = rec;
    }

    private void send(ShortMessage msg) throws InvalidMidiDataException {
        this.rec.send(msg, System.currentTimeMillis());
    }

    public void display() {
        if (this.led > 0) {
            try {
                this.ledMsg.setMessage(144, this.led, this.value);
                this.send(this.ledMsg);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setValue(int value) {
        this.value = Math.min(127, Math.max(0, value));
        this.display();
        for (IntConsumer listener : this.listeners) {
            listener.accept(value);
        }
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public int getMax() {
        return 127;
    }

    @Override
    void update(int data) {
        if (this.isSwitch) {
            if (data != 0) {
                this.setValue(this.value == 0 ? data : 0);
            }
        } else {
            this.setValue(data);
        }
    }

    @Override
    public boolean isToggle() {
        return this.isSwitch;
    }

    @Override
    public void setToggle(boolean isSwitch) {
        this.isSwitch = isSwitch;
        this.display();
    }
}

