/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class FloatPolygon {
    private Rectangle bounds;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;

    public FloatPolygon() {
        this.npoints = 0;
        this.xpoints = new float[10];
        this.ypoints = new float[10];
    }

    public FloatPolygon(float[] xpoints, float[] ypoints) {
        if (xpoints.length != ypoints.length) {
            throw new IllegalArgumentException("xpoints.length!=ypoints.length");
        }
        this.npoints = xpoints.length;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public FloatPolygon(float[] xpoints, float[] ypoints, int npoints) {
        this.npoints = npoints;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public boolean contains(double x, double y) {
        boolean inside = false;
        int i = 0;
        int j = this.npoints - 1;
        while (i < this.npoints) {
            if ((double)this.ypoints[i] >= y != (double)this.ypoints[j] >= y && x > ((double)this.xpoints[j] - (double)this.xpoints[i]) * (y - (double)this.ypoints[i]) / ((double)this.ypoints[j] - (double)this.ypoints[i]) + (double)this.xpoints[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public boolean contains(float x, float y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public Rectangle2D.Double getFloatBounds() {
        if (this.npoints == 0) {
            return new Rectangle2D.Double();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.maxX = Float.MIN_VALUE;
        this.maxY = Float.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            float x = xpoints[i];
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            float y = ypoints[i];
            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);
        }
        int iMinX = (int)Math.floor(this.minX);
        int iMinY = (int)Math.floor(this.minY);
        this.bounds = new Rectangle(iMinX, iMinY, (int)((double)(this.maxX - (float)iMinX) + 0.5), (int)((double)(this.maxY - (float)iMinY) + 0.5));
    }

    public void addPoint(float x, float y) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.bounds = null;
    }

    public void addPoint(double x, double y) {
        this.addPoint((float)x, (float)y);
    }

    public FloatPolygon duplicate() {
        int n = this.npoints;
        float[] xpoints = new float[n];
        float[] ypoints = new float[n];
        System.arraycopy(this.xpoints, 0, xpoints, 0, n);
        System.arraycopy(this.ypoints, 0, ypoints, 0, n);
        return new FloatPolygon(xpoints, ypoints, n);
    }

    public double getLength(boolean isLine) {
        double dy;
        double dx;
        double length = 0.0;
        for (int i = 0; i < this.npoints - 1; ++i) {
            dx = this.xpoints[i + 1] - this.xpoints[i];
            dy = this.ypoints[i + 1] - this.ypoints[i];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        if (!isLine) {
            dx = this.xpoints[0] - this.xpoints[this.npoints - 1];
            dy = this.ypoints[0] - this.ypoints[this.npoints - 1];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        return length;
    }

    public FloatPolygon getConvexHull() {
        float[] xx = new float[this.npoints];
        float[] yy = new float[this.npoints];
        int n2 = 0;
        float smallestY = Float.MAX_VALUE;
        for (int i = 0; i < this.npoints; ++i) {
            float y = this.ypoints[i];
            if (!(y < smallestY)) continue;
            smallestY = y;
        }
        float smallestX = Float.MAX_VALUE;
        int p1 = 0;
        for (int i = 0; i < this.npoints; ++i) {
            float x = this.xpoints[i];
            float y = this.ypoints[i];
            if (y != smallestY || !(x < smallestX)) continue;
            smallestX = x;
            p1 = i;
        }
        int pstart = p1;
        boolean count = false;
        do {
            double x1 = this.xpoints[p1];
            double y1 = this.ypoints[p1];
            int p2 = p1;
            double x2 = 0.0;
            double y2 = 0.0;
            do {
                if (++p2 == this.npoints) {
                    p2 = 0;
                }
                if (p2 == p1) break;
                x2 = this.xpoints[p2];
                y2 = this.ypoints[p2];
            } while (x2 == x1 && y2 == y1);
            int p3 = p2 + 1;
            if (p3 == this.npoints) {
                p3 = 0;
            }
            if (p2 != p1) {
                do {
                    double x3 = this.xpoints[p3];
                    double y3 = this.ypoints[p3];
                    double determinate = x1 * (y2 - y3) - y1 * (x2 - x3) + (y3 * x2 - y2 * x3);
                    boolean collinearAndFurther = false;
                    if (determinate == 0.0 && p3 != p2) {
                        double d2sqr = this.sqr(x2 - x1) + this.sqr(y2 - y1);
                        double d3sqr = this.sqr(x3 - x1) + this.sqr(y3 - y1);
                        boolean bl = collinearAndFurther = d3sqr > d2sqr;
                    }
                    if (determinate > 0.0 || collinearAndFurther) {
                        x2 = x3;
                        y2 = y3;
                        p2 = p3;
                    }
                    if (++p3 != this.npoints) continue;
                    p3 = 0;
                } while (p3 != p1);
            }
            xx[n2] = (float)x1;
            yy[n2] = (float)y1;
            ++n2;
            if (p2 == p1) break;
            p1 = p2;
        } while ((n2 <= 1 || this.xpoints[p1] != xx[0] || this.ypoints[p1] != yy[0]) && p1 != pstart);
        return new FloatPolygon(xx, yy, n2);
    }

    public synchronized void translate(double x, double y) {
        float fx = (float)x;
        float fy = (float)y;
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + fx;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + fy;
        }
    }

    private double sqr(double x) {
        return x * x;
    }

    private double crossProduct(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public String toString() {
        return "FloatPolygon[npoints=" + this.npoints + "]";
    }
}

