/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader;

import edu.utexas.clm.reconstructreader.reconstruct.ContourSet;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Utils {
    public static final String DELIM = " \t\n\r\f";

    private Utils() {
    }

    public static int sectionIndex(Node n) {
        Document d = n.getOwnerDocument();
        Element e = d.getDocumentElement();
        return Integer.valueOf(e.getAttribute("index"));
    }

    public static double[] getReconstructStackSize(List<Document> sections) {
        double maxImageHeight = 0.0;
        double maxImageWidth = 0.0;
        for (Document doc : sections) {
            NodeList images = doc.getElementsByTagName("Image");
            for (int i = 0; i < images.getLength(); ++i) {
                Node image = images.item(i);
                double[] wh = Utils.getReconstructImageWH(image);
                if (wh[0] > maxImageWidth) {
                    maxImageWidth = wh[0];
                }
                if (!(wh[1] > maxImageHeight)) continue;
                maxImageHeight = wh[1];
            }
        }
        return new double[]{maxImageWidth, maxImageHeight};
    }

    public static AffineTransform reconstructTransform(Element trans, double mag, double k) {
        return Utils.reconstructTransform(trans, mag, k, 1.0, true);
    }

    public static AffineTransform reconstructTransform(Element trans, double mag, double k, double zoom) {
        return Utils.reconstructTransform(trans, mag, k, zoom, false);
    }

    public static AffineTransform reconstructTransform(Element trans, double mag, double k, double zoom, boolean doFlip) {
        int dim = Integer.valueOf(trans.getAttribute("dim"));
        double[] matrix = new double[6];
        double[] xcoef = Utils.createNodeValueVector(trans.getAttribute("xcoef"));
        double[] ycoef = Utils.createNodeValueVector(trans.getAttribute("ycoef"));
        Utils.nodeValueToVector(trans.getAttribute("xcoef"), xcoef);
        Utils.nodeValueToVector(trans.getAttribute("ycoef"), ycoef);
        for (int i = 0; i < 6; ++i) {
            matrix[i] = 0.0;
        }
        switch (dim) {
            case 0: {
                matrix[0] = 1.0;
                matrix[3] = 1.0;
            }
            case 1: {
                matrix[0] = 1.0;
                matrix[3] = 1.0;
                matrix[4] = xcoef[0] / mag;
                matrix[5] = ycoef[0] / mag;
                break;
            }
            case 2: {
                matrix[0] = xcoef[1];
                matrix[3] = ycoef[1];
                matrix[4] = xcoef[0] / mag;
                matrix[5] = ycoef[0] / mag;
                break;
            }
            case 3: {
                matrix[0] = xcoef[1];
                matrix[1] = ycoef[1];
                matrix[2] = xcoef[2];
                matrix[3] = ycoef[2];
                matrix[4] = xcoef[0] / mag;
                matrix[5] = ycoef[0] / mag;
                break;
            }
            default: {
                int index = Integer.valueOf(trans.getOwnerDocument().getDocumentElement().getAttribute("index"));
                boolean weird = false;
                matrix[0] = xcoef[1];
                matrix[1] = ycoef[1];
                matrix[2] = xcoef[2];
                matrix[3] = ycoef[2];
                matrix[4] = xcoef[0] / mag;
                matrix[5] = ycoef[0] / mag;
                for (int i = 3; i < 6; ++i) {
                    weird |= xcoef[i] != 0.0 || ycoef[i] != 0.0;
                }
                if (!weird || trans.hasAttribute("weird")) break;
                System.err.println("Non affine tranforms are unsupported. Expect weirdness at index " + index);
                trans.setAttribute("weird", "true");
            }
        }
        AffineTransform at = new AffineTransform(matrix);
        try {
            at.invert();
        }
        catch (NoninvertibleTransformException nite) {
            System.err.println("Found noninvertible matrix, leaving it the way it is.");
        }
        at.getMatrix(matrix);
        double[] unFuckedMatrix = (double[])matrix.clone();
        if (doFlip) {
            unFuckedMatrix[1] = -matrix[1];
            unFuckedMatrix[2] = -matrix[2];
            unFuckedMatrix[4] = matrix[4] + k * matrix[2];
            unFuckedMatrix[5] = k - matrix[5] - k * matrix[3];
        }
        unFuckedMatrix[3] = unFuckedMatrix[3] * zoom;
        unFuckedMatrix[0] = unFuckedMatrix[0] * zoom;
        return new AffineTransform(unFuckedMatrix);
    }

    public static String transformToString(AffineTransform trans) {
        double[] mat = new double[6];
        trans.getMatrix(mat);
        return Utils.transformToString(mat);
    }

    public static String transformToString(double[] matrix) {
        StringBuilder transSB = new StringBuilder();
        Formatter f = new Formatter(transSB, Locale.US);
        transSB.append("matrix(");
        for (int i = 0; i < matrix.length - 1; ++i) {
            f.format("%f,", matrix[i]);
        }
        f.format("%f)", matrix[matrix.length - 1]);
        return transSB.toString();
    }

    public static double[] getReconstructBoundingBox(double[] wh, AffineTransform trans) {
        double x = wh[0];
        double y = wh[1];
        double[] xy = new double[]{0.0, 0.0, x, 0.0, x, y, 0.0, y};
        trans.transform(xy, 0, xy, 0, 4);
        return xy;
    }

    public static Element findElementByAttributeRegex(NodeList list, String name, String regex) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            if (list.item(i).getNodeType() != 1 || !(e = (Element)list.item(i)).hasAttribute(name) || !e.getAttribute(name).matches(regex)) continue;
            return e;
        }
        return null;
    }

    public static Element findElementByAttribute(NodeList list, String name, String value) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element e;
            if (list.item(i).getNodeType() != 1 || !(e = (Element)list.item(i)).hasAttribute(name) || !e.getAttribute(name).equals(value)) continue;
            return e;
        }
        return null;
    }

    public static double[] createNodeValueVector(String val) {
        StringTokenizer tokr = new StringTokenizer(val, " \t\n\r\f,\"");
        return new double[tokr.countTokens()];
    }

    public static int nodeValueToVector(String val, double[] matrix) {
        int rCount = 0;
        int i = 0;
        if (val.startsWith("\"")) {
            val = val.substring(1);
        }
        if (val.endsWith("\"")) {
            val = val.substring(0, val.length());
        }
        StringTokenizer t = new StringTokenizer(val, DELIM);
        String tok = "";
        while (t.hasMoreElements() && !(tok = t.nextToken()).contains(",")) {
            ++rCount;
        }
        if (tok.contains(",")) {
            ++rCount;
        }
        t = new StringTokenizer(val, " \t\n\r\f,\"");
        while (t.hasMoreElements()) {
            matrix[i++] = Float.valueOf(t.nextToken()).floatValue();
        }
        return rCount;
    }

    public static Element getFirstImageTransformElement(Document doc) {
        NodeList transforms = doc.getElementsByTagName("Transform");
        for (int i = 0; i < transforms.getLength(); ++i) {
            Element transform = (Element)transforms.item(i);
            NodeList children = transform.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("Image")) continue;
                return transform;
            }
        }
        return null;
    }

    public static ArrayList<Element> getImageTransformElements(Document doc) {
        ArrayList<Element> transformList = new ArrayList<Element>(3);
        NodeList transforms = doc.getElementsByTagName("Transform");
        for (int i = 0; i < transforms.getLength(); ++i) {
            Element transform = (Element)transforms.item(i);
            NodeList children = transform.getChildNodes();
            boolean found = false;
            for (int j = 0; j < children.getLength() && !found; ++j) {
                if (!children.item(j).getNodeName().equals("Image")) continue;
                transformList.add(transform);
                found = true;
            }
        }
        return transformList;
    }

    public static double[] getReconstructImageWH(Node image) {
        return Utils.getReconstructImageWH(image, null);
    }

    public static Element getImageDomainContour(Node image) {
        NodeList imageContourList = ((Element)image.getParentNode()).getElementsByTagName("Contour");
        return (Element)imageContourList.item(0);
    }

    public static double[] getReconstructImageWH(Node image, double[] wh) {
        if (null == image) {
            return new double[]{Double.NaN, Double.NaN};
        }
        Element imageDomainContour = Utils.getImageDomainContour(image);
        if (null == wh) {
            wh = new double[2];
        }
        if (null != imageDomainContour) {
            String pointsString = imageDomainContour.getAttribute("points");
            double[] points = Utils.createNodeValueVector(pointsString);
            Utils.nodeValueToVector(pointsString, points);
            wh[0] = points[2] + 1.0;
            wh[1] = points[5] + 1.0;
        } else {
            wh[0] = Double.NaN;
            wh[1] = Double.NaN;
        }
        return wh;
    }

    public static <T extends ContourSet> T findContourByName(List<T> contours, String name) {
        if (name != null) {
            for (ContourSet t : contours) {
                if (!t.getName().equals(name)) continue;
                return (T)t;
            }
        }
        return null;
    }

    public static void selectElementsByIndex(List<Element> elementList, List<Integer> indexList, List<Element> outputList, int index) {
        for (int i = 0; i < indexList.size(); ++i) {
            if (!indexList.get(i).equals(index)) continue;
            outputList.add(elementList.get(i));
        }
    }

    public static void appendOpenPathXML(StringBuilder sb, double[] dpts) {
        float[] pts = Utils.doubleToFloat(dpts);
        sb.append("M ").append(pts[0]).append(" ").append(pts[1]).append(" ");
        for (int i = 2; i < pts.length; i += 2) {
            sb.append("L ").append(pts[i]).append(" ").append(pts[i + 1]).append(" ");
        }
    }

    public static void appendClosedPathXML(StringBuilder sb, double[] pts) {
        Utils.appendOpenPathXML(sb, pts);
        sb.append("z");
    }

    public static void appendBezierPathXML(StringBuilder sb, double[] dpts) {
        float[] pts = Utils.doubleToFloat(dpts);
        if (pts.length > 0) {
            sb.append("M ").append(pts[0]).append(",").append(pts[1]).append(" ");
            for (int i = 2; i < pts.length; i += 2) {
                sb.append("C ").append(pts[i - 2]).append(",").append(pts[i - 1]).append(" ").append(pts[i]).append(",").append(pts[i + 1]).append(" ").append(pts[i]).append(",").append(pts[i + 1]);
            }
        }
    }

    public static String hexColor(String inColor) {
        String hex = "";
        double[] colorTriad = new double[3];
        Utils.nodeValueToVector(inColor, colorTriad);
        for (int i = 0; i < 3; ++i) {
            String simplexHex = Integer.toHexString((int)colorTriad[i] * 255);
            if (simplexHex.length() < 2) {
                simplexHex = "0" + simplexHex;
            }
            hex = hex + simplexHex;
        }
        return hex;
    }

    public static double getMag(Document d) {
        NodeList nl = d.getElementsByTagName("Image");
        if (nl.getLength() == 0) {
            return Double.NaN;
        }
        return Double.valueOf(((Element)nl.item(0)).getAttribute("mag"));
    }

    public static double getMag(Node n) {
        Document d = n.getOwnerDocument();
        return Utils.getMag(d);
    }

    public static double[] getTransformedPoints(Element contour, double stackHeight, double mag) {
        boolean isDomainContour = contour.getAttribute("name").startsWith("domain");
        double zoom = isDomainContour ? 1.0 : 1.0 / mag;
        double useMag = isDomainContour ? mag : 1.0;
        AffineTransform trans = Utils.reconstructTransform((Element)contour.getParentNode(), useMag, stackHeight, zoom, isDomainContour);
        String contourValue = contour.getAttribute("points");
        if (contourValue.trim().length() < 1) {
            return new double[0];
        }
        double[] pts = Utils.createNodeValueVector(contour.getAttribute("points"));
        int nrows = Utils.nodeValueToVector(contour.getAttribute("points"), pts);
        if (nrows != 2) {
            System.err.println("Nrows should have been 2, instead it was " + nrows + ", therefore, we're boned");
            System.err.println("Points text: " + contour.getAttribute("points"));
            System.err.println("Problem encountered while processing " + contour.getAttribute("name"));
        }
        trans.transform(pts, 0, pts, 0, pts.length / 2);
        if (!isDomainContour) {
            for (int i = 1; i < pts.length; i += 2) {
                pts[i] = stackHeight - pts[i];
            }
        }
        return pts;
    }

    public static double[] getPathExtent(double[] pts) {
        double[] wh = new double[]{0.0, 0.0};
        for (int i = 0; i < pts.length; i += 2) {
            if (pts[i] > wh[0]) {
                wh[0] = pts[i];
            }
            if (!(pts[i + 1] > wh[1])) continue;
            wh[1] = pts[i + 1];
        }
        return wh;
    }

    public static double getMedianMag(List<Document> sectionList) {
        ArrayList<Double> magList = new ArrayList<Double>(sectionList.size());
        for (Document d : sectionList) {
            double m = Utils.getMag(d);
            if (Double.isNaN(m)) continue;
            magList.add(m);
        }
        Collections.sort(magList);
        return (Double)magList.get(magList.size() / 2);
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return result.toString();
    }

    public static float[] doubleToFloat(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    public static ArrayList<String> getSeriesKeys() {
        ArrayList<String> keys = new ArrayList<String>(128);
        keys.add("viewport");
        keys.add("units");
        keys.add("autoSaveSeries");
        keys.add("autoSaveSection");
        keys.add("warnSaveSection");
        keys.add("beepDeleting");
        keys.add("beepPaging");
        keys.add("hideTraces");
        keys.add("unhideTraces");
        keys.add("hideDomains");
        keys.add("unhideDomains");
        keys.add("useAbsolutePaths");
        keys.add("defaultThickness");
        keys.add("zMidSection");
        keys.add("thumbWidth");
        keys.add("thumbHeight");
        keys.add("fitThumbSections");
        keys.add("firstThumbSection");
        keys.add("lastThumbSection");
        keys.add("skipSections");
        keys.add("displayThumbContours");
        keys.add("useFlipbookStyle");
        keys.add("flipRate");
        keys.add("useProxies");
        keys.add("widthUseProxies");
        keys.add("heightUseProxies");
        keys.add("scaleProxies");
        keys.add("significantDigits");
        keys.add("defaultBorder");
        keys.add("defaultFill");
        keys.add("defaultMode");
        keys.add("defaultName");
        keys.add("defaultComment");
        keys.add("listSectionThickness");
        keys.add("listDomainSource");
        keys.add("listDomainPixelsize");
        keys.add("listDomainLength");
        keys.add("listDomainArea");
        keys.add("listDomainMidpoint");
        keys.add("listTraceComment");
        keys.add("listTraceLength");
        keys.add("listTraceArea");
        keys.add("listTraceCentroid");
        keys.add("listTraceExtent");
        keys.add("listTraceZ");
        keys.add("listTraceThickness");
        keys.add("listObjectRange");
        keys.add("listObjectCount");
        keys.add("listObjectSurfarea");
        keys.add("listObjectFlatarea");
        keys.add("listObjectVolume");
        keys.add("listZTraceNote");
        keys.add("listZTraceRange");
        keys.add("listZTraceLength");
        keys.add("borderColors");
        keys.add("fillColors");
        keys.add("offset3D");
        keys.add("type3Dobject");
        keys.add("first3Dsection");
        keys.add("last3Dsection");
        keys.add("max3Dconnection");
        keys.add("upper3Dfaces");
        keys.add("lower3Dfaces");
        keys.add("faceNormals");
        keys.add("vertexNormals");
        keys.add("facets3D");
        keys.add("dim3D");
        keys.add("gridType");
        keys.add("gridSize");
        keys.add("gridDistance");
        keys.add("gridNumber");
        keys.add("hueStopWhen");
        keys.add("hueStopValue");
        keys.add("satStopWhen");
        keys.add("satStopValue");
        keys.add("brightStopWhen");
        keys.add("brightStopValue");
        keys.add("tracesStopWhen");
        keys.add("areaStopPercent");
        keys.add("areaStopSize");
        keys.add("ContourMaskWidth");
        keys.add("smoothingLength");
        keys.add("mvmtIncrement");
        keys.add("ctrlIncrement");
        keys.add("shiftIncrement");
        return keys;
    }

    public static class ReconstructSectionIndexComparator
    implements Comparator<Document> {
        @Override
        public int compare(Document o1, Document o2) {
            Integer index1 = Integer.valueOf(o1.getDocumentElement().getAttribute("index"));
            Integer index2 = Integer.valueOf(o2.getDocumentElement().getAttribute("index"));
            return index1.compareTo(index2);
        }
    }
}

