/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.BoundedValue;

public class BoundedInterval {
    private final BoundedValue minValue;
    private final BoundedValue maxValue;
    protected final int minIntervalSize;

    public BoundedInterval(int rangeMin, int rangeMax, int initialMin, int initialMax, final int minIntervalSize) {
        this.minIntervalSize = minIntervalSize;
        this.minValue = new BoundedValue(rangeMin, rangeMax - minIntervalSize, initialMin){

            @Override
            public void setCurrentValue(int value) {
                super.setCurrentValue(value);
                int min = BoundedInterval.this.minValue.getCurrentValue();
                int max = BoundedInterval.this.maxValue.getCurrentValue();
                if (min > max - minIntervalSize) {
                    max = min + minIntervalSize;
                    BoundedInterval.this.maxValue.setCurrentValue(max);
                }
                BoundedInterval.this.updateInterval(min, max);
            }
        };
        this.maxValue = new BoundedValue(rangeMin + minIntervalSize, rangeMax, initialMax){

            @Override
            public void setCurrentValue(int value) {
                super.setCurrentValue(value);
                int min = BoundedInterval.this.minValue.getCurrentValue();
                int max = BoundedInterval.this.maxValue.getCurrentValue();
                if (min > max - minIntervalSize) {
                    min = max - minIntervalSize;
                    BoundedInterval.this.minValue.setCurrentValue(min);
                }
                BoundedInterval.this.updateInterval(min, max);
            }
        };
    }

    protected void updateInterval(int min, int max) {
    }

    public BoundedValue getMinBoundedValue() {
        return this.minValue;
    }

    public BoundedValue getMaxBoundedValue() {
        return this.maxValue;
    }

    public int getRangeMin() {
        return this.minValue.getRangeMin();
    }

    public int getRangeMax() {
        return this.maxValue.getRangeMax();
    }

    public void setRange(int min, int max) {
        assert (min < max - this.minIntervalSize);
        this.minValue.setRange(min, max - this.minIntervalSize);
        this.maxValue.setRange(min + this.minIntervalSize, max);
        int currentMin = this.minValue.getCurrentValue();
        int currentMax = this.maxValue.getCurrentValue();
        if (currentMin > currentMax - this.minIntervalSize) {
            if (currentMax == max) {
                this.minValue.setCurrentValue(currentMax - this.minIntervalSize);
            } else {
                this.maxValue.setCurrentValue(currentMin + this.minIntervalSize);
            }
        }
    }
}

