/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.geometry.GeometryVector;
import org.ojalgo.matrix.store.operation.MultiplyBoth;

public class Primitive32Vector3
extends GeometryVector {
    public float v0;
    public float v1;
    public float v2;

    public Primitive32Vector3() {
        super(MultiplyBoth.getPrimitive(3L, 1L), 3L, 1L);
    }

    public Primitive32Vector3(float v0, float v1, float v2) {
        this();
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public final void add(int row, double addend) {
        switch (row) {
            case 0: {
                this.v0 = (float)((double)this.v0 + addend);
                break;
            }
            case 1: {
                this.v1 = (float)((double)this.v1 + addend);
                break;
            }
            case 2: {
                this.v2 = (float)((double)this.v2 + addend);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final long count() {
        return 3L;
    }

    @Override
    public final double doubleValue(int index) {
        switch (index) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
            case 2: {
                return this.v2;
            }
        }
        throw new IllegalArgumentException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive32Vector3)) {
            return false;
        }
        Primitive32Vector3 other = (Primitive32Vector3)obj;
        if (Float.floatToIntBits(this.v0) != Float.floatToIntBits(other.v0)) {
            return false;
        }
        if (Float.floatToIntBits(this.v1) != Float.floatToIntBits(other.v1)) {
            return false;
        }
        return Float.floatToIntBits(this.v2) == Float.floatToIntBits(other.v2);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.v0);
        result = 31 * result + Float.floatToIntBits(this.v1);
        result = 31 * result + Float.floatToIntBits(this.v2);
        return result;
    }

    @Override
    public final void modifyOne(int row, UnaryFunction<Double> modifier) {
        switch (row) {
            case 0: {
                this.v0 = (float)modifier.invoke(this.v0);
                break;
            }
            case 1: {
                this.v1 = (float)modifier.invoke(this.v1);
                break;
            }
            case 2: {
                this.v2 = (float)modifier.invoke(this.v2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final void set(int row, double value) {
        switch (row) {
            case 0: {
                this.v0 = (float)value;
                break;
            }
            case 1: {
                this.v1 = (float)value;
                break;
            }
            case 2: {
                this.v2 = (float)value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

