/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive64Vector2;
import org.ojalgo.matrix.geometry.Primitive64Vector3;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive64Matrix3
implements GeometryMatrix<Primitive64Matrix3>,
TransformationMatrix<Double, Primitive64Vector3> {
    public double m00;
    public double m10;
    public double m20;
    public double m01;
    public double m11;
    public double m21;
    public double m02;
    public double m12;
    public double m22;

    public Primitive64Matrix3() {
    }

    public Primitive64Matrix3(double m00, double m10, double m20, double m01, double m11, double m21, double m02, double m12, double m22) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
    }

    @Override
    public final long countColumns() {
        return 3L;
    }

    @Override
    public final long countRows() {
        return 3L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                    case 2: {
                        return this.m20;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m21;
                    }
                }
            }
            case 2: {
                switch (row) {
                    case 0: {
                        return this.m02;
                    }
                    case 1: {
                        return this.m12;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive64Matrix3)) {
            return false;
        }
        Primitive64Matrix3 other = (Primitive64Matrix3)obj;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(other.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(other.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(other.m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(other.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(other.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(other.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(other.m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(other.m21)) {
            return false;
        }
        return Double.doubleToLongBits(this.m22) == Double.doubleToLongBits(other.m22);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m02);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m12);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m20);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m21);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m22);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public final void multiply(Primitive64Vector2 right, double right2, Primitive64Vector2 product) {
        double right0 = right.v0;
        double right1 = right.v1;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2;
    }

    public final void multiply(Primitive64Vector3 right, Primitive64Vector3 product) {
        double right0 = right.v0;
        double right1 = right.v1;
        double right2 = right.v2;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2;
    }

    @Override
    public final void negate(Primitive64Matrix3 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m02 = -matrix.m02;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
        this.m12 = -matrix.m12;
        this.m20 = -matrix.m20;
        this.m21 = -matrix.m21;
        this.m22 = -matrix.m22;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    public final void transform(Primitive64Vector2 transformable, double v2) {
        this.multiply(transformable, v2, transformable);
    }

    @Override
    public final void transform(Primitive64Vector3 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive64Matrix3 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m02 = matrix.m20;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
        this.m12 = matrix.m21;
        this.m20 = matrix.m02;
        this.m21 = matrix.m12;
        this.m22 = matrix.m22;
    }
}

