/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.AbstractDeterminator;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public interface DeterminantTask<N extends Number>
extends MatrixTask<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public DeterminantTask<BigDecimal> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.BIG.make(template);
            }
            return (DeterminantTask)LU.BIG.make(template);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public DeterminantTask<ComplexNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.COMPLEX.make(template);
            }
            return (DeterminantTask)LU.COMPLEX.make(template);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public DeterminantTask<Double> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            long tmpDim = template.countRows();
            if (tmpDim == 1L) {
                return AbstractDeterminator.FULL_1X1;
            }
            if (symmetric) {
                if (tmpDim == 2L) {
                    return AbstractDeterminator.SYMMETRIC_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractDeterminator.SYMMETRIC_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractDeterminator.SYMMETRIC_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractDeterminator.SYMMETRIC_5X5;
                }
                return positiveDefinite ? (DeterminantTask)Cholesky.PRIMITIVE.make(template) : (DeterminantTask)LU.PRIMITIVE.make(template);
            }
            if (tmpDim == 2L) {
                return AbstractDeterminator.FULL_2X2;
            }
            if (tmpDim == 3L) {
                return AbstractDeterminator.FULL_3X3;
            }
            if (tmpDim == 4L) {
                return AbstractDeterminator.FULL_4X4;
            }
            if (tmpDim == 5L) {
                return AbstractDeterminator.FULL_5X5;
            }
            return (DeterminantTask)LU.PRIMITIVE.make(template);
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        public DeterminantTask<Quaternion> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.QUATERNION.make(template);
            }
            return (DeterminantTask)LU.QUATERNION.make(template);
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        public DeterminantTask<RationalNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.RATIONAL.make(template);
            }
            return (DeterminantTask)LU.RATIONAL.make(template);
        }
    };

    public N calculateDeterminant(Access2D<?> var1);

    public static abstract class Factory<N extends Number> {
        public final DeterminantTask<N> make(final int dim, boolean symmetric) {
            Structure2D template = new Structure2D(){

                @Override
                public long countColumns() {
                    return dim;
                }

                @Override
                public long countRows() {
                    return dim;
                }
            };
            return this.make(template, symmetric, false);
        }

        public final DeterminantTask<N> make(MatrixStore<N> template) {
            return this.make(template, MatrixUtils.isHermitian(template), false);
        }

        public abstract DeterminantTask<N> make(Structure2D var1, boolean var2, boolean var3);
    }
}

