/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureListener;
import org.jhotdraw.draw.tool.TextEditingTool;
import org.jhotdraw.draw.tool.Tool;

public class LabelFigure
extends TextFigure
implements FigureListener {
    @Nullable
    private TextHolderFigure target;

    public LabelFigure() {
        this("Label");
    }

    public LabelFigure(String text) {
        this.setText(text);
        this.setEditable(false);
    }

    public void setLabelFor(TextHolderFigure target) {
        if (this.target != null) {
            this.target.removeFigureListener(this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.addFigureListener(this);
        }
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this.target == null ? this : this.target;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        return this.target != null && this.contains(p) ? new TextEditingTool(this.target) : null;
    }

    @Override
    public void areaInvalidated(FigureEvent e) {
    }

    @Override
    public void attributeChanged(FigureEvent e) {
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
        if (e.getFigure() == this.target) {
            this.target.removeFigureListener(this);
            this.target = null;
        }
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void remap(Map<Figure, Figure> oldToNew, boolean disconnectIfNotInMap) {
        Figure newTarget;
        super.remap(oldToNew, disconnectIfNotInMap);
        if (this.target != null && (newTarget = oldToNew.get(this.target)) != null) {
            this.target.removeFigureListener(this);
            this.target = (TextHolderFigure)newTarget;
            newTarget.addFigureListener(this);
        }
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }
}

