/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.geom.Point2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class PaletteButtonBorder
implements Border,
UIResource {
    private static final float[] enabledStops = new float[]{0.0f, 0.35f, 0.4f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF8F8F8), new Color(0xEEEEEE), new Color(0xCACACA), new Color(0xFFFFFF)};
    private static final float[] selectedStops = new float[]{0.0f, 0.1f, 0.9f, 1.0f};
    private static final Color[] selectedStopColors = new Color[]{new Color(0x666666), new Color(0xCCCCCC), new Color(0x999999), new Color(0xB1B1B1)};

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof AbstractButton) {
            this.paintBorder((AbstractButton)c, g, x, y, width, height);
        }
    }

    public void paintBorder(AbstractButton c, Graphics gr, int x, int y, int width, int height) {
        Color[] stopColors;
        float[] stops;
        int borderColor;
        Graphics2D g = (Graphics2D)gr;
        ButtonModel m = c.getModel();
        if (!m.isEnabled()) {
            borderColor = -2136627803;
            stops = enabledStops;
            stopColors = enabledStopColors;
        } else if (m.isSelected() || m.isPressed() && m.isArmed()) {
            borderColor = -13421773;
            stops = selectedStops;
            stopColors = selectedStopColors;
        } else {
            borderColor = -5921371;
            stops = enabledStops;
            stopColors = enabledStopColors;
        }
        String segmentPosition = this.getSegmentPosition(c);
        if (segmentPosition == "first" || segmentPosition == "middle") {
            ++width;
        }
        g.setColor(new Color(borderColor, true));
        g.drawRect(x, y, width - 1, height - 1);
        LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(x, y), new Point2D.Float(x, y + height - 1), stops, stopColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g.setPaint(lgp);
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
    }

    private String getSegmentPosition(Component c) {
        String segmentPosition = null;
        if (c instanceof JComponent) {
            segmentPosition = (String)((JComponent)c).getClientProperty("Palette.Component.segmentPosition");
        }
        return segmentPosition == null ? "only" : segmentPosition;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        String segmentPosition = this.getSegmentPosition(c);
        Insets insets = segmentPosition == "first" || segmentPosition == "middle" ? new Insets(3, 3, 3, 2) : new Insets(3, 3, 3, 3);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

