/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class JavaNumberFormatter
extends DefaultFormatter {
    private boolean allowsNullValue = false;
    private Comparable min;
    private Comparable max;
    @Nullable
    private String unit;
    private DecimalFormat decimalFormat;
    private DecimalFormat scientificFormat;
    private double multiplier = 1.0;
    private int minIntDigits;
    private int maxIntDigits;
    private int minFractionDigits;
    private int maxFractionDigits;
    private int minNegativeExponent = -3;
    private int minPositiveExponent = 8;
    private boolean usesScientificNotation = true;

    public JavaNumberFormatter() {
        this.initFormats();
    }

    public JavaNumberFormatter(double min, double max, double multiplier) {
        this(min, max, multiplier, false, null);
    }

    public JavaNumberFormatter(double min, double max, double multiplier, boolean allowsNullValue) {
        this(min, max, multiplier, allowsNullValue, null);
    }

    public JavaNumberFormatter(double min, double max, double multiplier, boolean allowsNullValue, @Nullable String unit) {
        this.initFormats();
        this.setMinimum(Double.valueOf(min));
        this.setMaximum(Double.valueOf(max));
        this.setMultiplier(multiplier);
        this.setAllowsNullValue(allowsNullValue);
        this.setOverwriteMode(false);
        this.setUnit(unit);
    }

    private void initFormats() {
        DecimalFormatSymbols s = new DecimalFormatSymbols(Locale.ENGLISH);
        this.decimalFormat = new DecimalFormat("#################0.#################", s);
        this.scientificFormat = new DecimalFormat("0.0################E0", s);
    }

    public void setMinimum(Comparable minimum) {
        if (this.getValueClass() == null && minimum != null) {
            this.setValueClass(minimum.getClass());
        }
        this.min = minimum;
    }

    public Comparable getMinimum() {
        return this.min;
    }

    public void setMaximum(Comparable max) {
        if (this.getValueClass() == null && max != null) {
            this.setValueClass(max.getClass());
        }
        this.max = max;
    }

    public Comparable getMaximum() {
        return this.max;
    }

    public void setMultiplier(double newValue) {
        this.multiplier = newValue;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setMinimumFractionDigits(int newValue) {
        this.minFractionDigits = newValue;
        this.decimalFormat.setMinimumFractionDigits(newValue);
    }

    public int getMinimumFractionDigits() {
        return this.minFractionDigits;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null && this.allowsNullValue) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (value instanceof Double) {
            double v = (Double)value;
            BigDecimal big = new BigDecimal(v *= this.multiplier);
            int exponent = big.scale() >= 0 ? big.precision() - big.scale() : -big.scale();
            String str = !this.usesScientificNotation || exponent > this.minNegativeExponent && exponent < this.minPositiveExponent ? this.decimalFormat.format(v) : this.scientificFormat.format(v);
            buf.append(str);
        } else if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            BigDecimal big = new BigDecimal(v = (float)((double)v * this.multiplier));
            int exponent = big.scale() >= 0 ? big.precision() - big.scale() : -big.scale();
            String str = !this.usesScientificNotation || exponent > this.minNegativeExponent && exponent < this.minPositiveExponent ? this.decimalFormat.format(v) : this.scientificFormat.format(v);
            buf.append(str);
        } else if (value instanceof Long) {
            long v = (Long)value;
            v = (long)((double)v * this.multiplier);
            buf.append(Long.toString(v));
        } else if (value instanceof Integer) {
            int v = (Integer)value;
            v = (int)((double)v * this.multiplier);
            buf.append(Integer.toString(v));
        } else if (value instanceof Byte) {
            byte v = (Byte)value;
            v = (byte)((double)v * this.multiplier);
            buf.append(Byte.toString(v));
        } else if (value instanceof Short) {
            short v = (Short)value;
            v = (short)((double)v * this.multiplier);
            buf.append(Short.toString(v));
        }
        if (buf.length() != 0) {
            if (this.unit != null) {
                buf.append(this.unit);
            }
            return buf.toString();
        }
        throw new ParseException("Value is of unsupported class " + value, 0);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Number value;
        Class<?> valueClass;
        int p;
        if ((text == null || text.length() == 0) && this.getAllowsNullValue()) {
            return null;
        }
        if (this.unit != null && (p = text.lastIndexOf(this.unit)) != -1) {
            text = text.substring(0, p);
        }
        if ((valueClass = this.getValueClass()) != null) {
            try {
                if (valueClass == Integer.class) {
                    int v = Integer.parseInt(text);
                    v = (int)((double)v / this.multiplier);
                    value = v;
                }
                if (valueClass == Long.class) {
                    long v = Long.parseLong(text);
                    v = (long)((double)v / this.multiplier);
                    value = v;
                }
                if (valueClass == Float.class) {
                    float v = Float.parseFloat(text);
                    v = (float)((double)v / this.multiplier);
                    value = new Float(v);
                }
                if (valueClass == Double.class) {
                    double v = Double.parseDouble(text);
                    value = new Double(v /= this.multiplier);
                }
                if (valueClass == Byte.class) {
                    byte v = Byte.parseByte(text);
                    v = (byte)((double)v / this.multiplier);
                    value = v;
                }
                if (valueClass == Short.class) {
                    short v = Short.parseShort(text);
                    v = (short)((double)v / this.multiplier);
                    value = v;
                }
                throw new ParseException("Unsupported value class " + valueClass, 0);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        } else {
            throw new ParseException("Unsupported value class " + valueClass, 0);
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return value;
    }

    boolean isValidValue(Object value, boolean wantsCCE) {
        try {
            if (this.min != null && this.min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        try {
            if (this.max != null && this.max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    public void setUnit(@Nullable String value) {
        this.unit = value;
    }

    @Nullable
    public String getUnit() {
        return this.unit;
    }

    public int getMinimumIntegerDigits() {
        return this.minIntDigits;
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.decimalFormat.setMinimumIntegerDigits(newValue);
        this.scientificFormat.setMinimumIntegerDigits(newValue);
        this.minIntDigits = newValue;
    }

    public int getMaximumIntegerDigits() {
        return this.maxIntDigits;
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.decimalFormat.setMaximumIntegerDigits(newValue);
        this.scientificFormat.setMaximumIntegerDigits(newValue);
        this.maxIntDigits = newValue;
    }

    public int getMaximumFractionDigits() {
        return this.maxFractionDigits;
    }

    public void setMaximumFractionDigits(int newValue) {
        this.decimalFormat.setMaximumFractionDigits(newValue);
        this.scientificFormat.setMaximumFractionDigits(newValue);
        this.maxFractionDigits = newValue;
    }

    public int getMinimumNegativeExponent() {
        return this.minNegativeExponent;
    }

    public void setMinimumNegativeExponent(int newValue) {
        this.minNegativeExponent = newValue;
    }

    public int getMinimumPositiveExponent() {
        return this.minPositiveExponent;
    }

    public void setMinimumPositiveExponent(int newValue) {
        this.minPositiveExponent = newValue;
    }

    public boolean isUsesScientificNotation() {
        return this.usesScientificNotation;
    }

    public void setUsesScientificNotation(boolean newValue) {
        this.usesScientificNotation = newValue;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double min, double max, double multiplier) {
        return JavaNumberFormatter.createFormatterFactory(min, max, multiplier, false, null);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double min, double max, double multiplier, boolean allowsNullValue) {
        JavaNumberFormatter formatter = new JavaNumberFormatter(min, max, multiplier, allowsNullValue, null);
        return new DefaultFormatterFactory(formatter);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double min, double max, double multiplier, boolean allowsNullValue, @Nullable String unit) {
        JavaNumberFormatter formatter = new JavaNumberFormatter(min, max, multiplier, allowsNullValue, unit);
        return new DefaultFormatterFactory(formatter);
    }
}

