/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import vib.InterpolatedImage;
import vib.segment.CustomCanvas;
import vib.segment.ImageButton;
import vib.segment.MaterialList;

public class Sidebar
extends Panel
implements CustomCanvas.CanvasListener,
ItemListener {
    private CustomCanvas cc;
    private Font font = new Font("Helvetica", 0, 10);
    private GridBagConstraints constr;
    private Label lZoomLevel;
    private ImageButton bZoomPlus;
    private ImageButton bZoomMinus;
    private ImageButton bPlus;
    private ImageButton bMinus;
    private ImageButton bInterpolate;
    private ImageButton bThreshold;
    private ImageButton bOpen;
    private ImageButton bClose;
    private Checkbox check3d;
    private Choice labelImagesChoice;
    private Vector labelImages;
    private ActionListener al;
    private MaterialList materials;
    private Vector defaultMaterials;
    private boolean currentLabelsAreNew = false;

    public Sidebar(CustomCanvas cc, ActionListener al) {
        this.cc = cc;
        this.al = al;
        cc.addCanvasListener(this);
        this.setLayout(new GridBagLayout());
        this.constr = new GridBagConstraints();
        this.constr.fill = 1;
        this.constr.anchor = 17;
        this.constr.gridwidth = 0;
        this.constr.insets = new Insets(0, 5, 0, 5);
        this.addLabel("Label sets:");
        this.add((Component)this.addLabelImageChoice(), this.constr);
        this.addLabel("Labels:");
        this.materials = new MaterialList(cc);
        this.add((Component)this.materials, this.constr);
        this.addZoom();
        this.addSelection();
        this.addTools();
        this.addHints();
        this.itemStateChanged(null);
    }

    public void updateLZoomLevel(double magnification) {
        this.lZoomLevel.setText(String.valueOf(magnification));
    }

    public boolean is3d() {
        return this.check3d.getState();
    }

    public int currentMaterialID() {
        return this.materials.currentMaterialID();
    }

    public MaterialList getMaterials() {
        return this.materials;
    }

    @Override
    public void magnificationChanged(double d) {
        this.updateLZoomLevel(d);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.materials.setBackground(bg);
    }

    public void setLabelImage(ImagePlus image) {
        if (image == null) {
            image = InterpolatedImage.cloneDimensionsOnly(this.cc.getImage(), 3).getImage();
            String originalTitle = this.cc.getImage().getTitle();
            String newName = "New Labels";
            if (originalTitle.length() > 0) {
                int lastDot = originalTitle.lastIndexOf(46);
                newName = lastDot >= 0 ? originalTitle.substring(0, lastDot) + ".labels" : originalTitle + ".labels";
            } else {
                image.setTitle(newName);
            }
            image.setTitle(newName);
        }
        this.cc.setLabels(image);
        this.cc.repaint();
        if (this.materials != null) {
            this.materials.initFrom(image);
            this.materials.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int selected = this.labelImagesChoice.getSelectedIndex();
        if (selected < this.labelImages.size()) {
            Object image = this.labelImages.get(selected);
            this.setLabelImage((ImagePlus)image);
            this.currentLabelsAreNew = false;
            this.cc.requestFocus();
            return;
        }
        String materials = (String)this.defaultMaterials.get(selected -= this.labelImages.size());
        if (!this.currentLabelsAreNew) {
            this.setLabelImage(null);
        }
        ImagePlus labels = this.cc.getLabels();
        AmiraParameters params = new AmiraParameters(materials);
        params.setParameters(labels);
        this.setLabelImage(labels);
        this.materials.params = params;
        this.currentLabelsAreNew = true;
        this.cc.requestFocus();
    }

    private ImageButton addImageButton(String path, ActionListener l) {
        Image img = null;
        try {
            URL url = this.getClass().getResource("icons/" + path);
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (img == null) {
            throw new RuntimeException("Image not found: " + path);
        }
        ImageButton button = new ImageButton(img);
        button.addActionListener(l);
        this.add((Component)button, this.constr);
        return button;
    }

    private Label addLabel(String txt) {
        this.constr.insets = new Insets(10, 5, 0, 5);
        Label label = new Label(txt);
        label.setFont(this.font);
        this.add((Component)label, this.constr);
        this.constr.insets = new Insets(0, 5, 0, 5);
        return label;
    }

    private Choice addLabelImageChoice() {
        this.labelImagesChoice = new Choice();
        this.labelImages = new Vector();
        this.defaultMaterials = new Vector();
        int count = WindowManager.getWindowCount();
        for (int i = 0; i < count; ++i) {
            ImagePlus image = WindowManager.getImage((int)(i + 1));
            if (!AmiraParameters.isAmiraLabelfield(image) || image == this.cc.getImage() || image.getWidth() != this.cc.getImage().getWidth() || image.getHeight() != this.cc.getImage().getHeight() || image.getStack().getSize() != this.cc.getImage().getStack().getSize()) continue;
            this.labelImagesChoice.add(image.getTitle());
            this.labelImages.add(image);
        }
        this.labelImagesChoice.add("<new>");
        this.defaultMaterials.add("Parameters {\n\tMaterials {\n\t\tExterior {\n\t\t\tColor 0.0 0.0 0.0\n\t\t}\n\t\tInterior {\n\t\t\tColor 1.0 0.0 0.0\n\t\t}\n\t}\n}\n");
        URL materials = this.getClass().getResource("materials/CompactStandard");
        String contents = this.readURL(materials);
        this.defaultMaterials.add(contents);
        this.labelImagesChoice.add("CompactStandard");
        this.labelImagesChoice.addItemListener(this);
        return this.labelImagesChoice;
    }

    private void addZoom() {
        this.addLabel("Zoom:");
        this.constr.gridwidth = 1;
        this.bZoomPlus = this.addImageButton("iconZoomPlus.png", this.al);
        this.bZoomPlus.setActionCommand("zoomin");
        this.bZoomMinus = this.addImageButton("iconZoomMinus.png", this.al);
        this.bZoomMinus.setActionCommand("zoomout");
        this.constr.gridwidth = 0;
        this.constr.fill = 0;
        this.lZoomLevel = this.addLabel(String.valueOf(this.cc.getMagnification()));
        this.constr.fill = 1;
    }

    private void addSelection() {
        this.constr.gridwidth = 0;
        this.addLabel("Selection:");
        this.constr.gridwidth = 1;
        this.bPlus = this.addImageButton("iconPlus.png", this.al);
        this.bPlus.setActionCommand("plus");
        this.bMinus = this.addImageButton("iconMinus.png", this.al);
        this.bMinus.setActionCommand("minus");
        this.constr.gridwidth = 0;
        this.constr.fill = 0;
        this.check3d = new Checkbox("3d", true);
        this.add((Component)this.check3d, this.constr);
        this.constr.fill = 1;
    }

    private void addTools() {
        this.constr.gridwidth = 0;
        this.addLabel("Tools:");
        this.constr.gridwidth = 1;
        this.bInterpolate = this.addImageButton("iconInterpolate.png", this.al);
        this.bInterpolate.setActionCommand("interpolate");
        this.bThreshold = this.addImageButton("iconThreshold.png", this.al);
        this.bThreshold.setActionCommand("threshold");
        this.bOpen = this.addImageButton("iconOpen.png", this.al);
        this.bOpen.setActionCommand("open");
        this.constr.gridwidth = 0;
        this.constr.fill = 0;
        this.bClose = this.addImageButton("iconClose.png", this.al);
        this.bClose.setActionCommand("close");
        this.constr.fill = 1;
    }

    private void addHints() {
        Font keyFont = new Font("Monospaced", 0, 12);
        this.addLabel("Hints:");
        Label label = new Label("Jump to prev/next selection:");
        label.setFont(this.font);
        this.add((Component)label, this.constr);
        label = new Label("\",\"\t/\t\".\"");
        label.setFont(keyFont);
        this.add((Component)label, this.constr);
    }

    private String readURL(URL url) {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            InputStream input = url.openStream();
            while ((c = input.read()) != -1) {
                buffer.append((char)c);
            }
            return new String(buffer);
        }
        catch (Exception e) {
            return null;
        }
    }
}

