/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.GenericDialog;
import java.awt.Color;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.ij.InteractiveMapping;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;
import mpicbg.trakem2.transform.ThinPlateSplineTransform;

public class Transform_ThinPlateSpline
extends InteractiveMapping {
    public static final String NL = System.getProperty("line.separator");
    public static final String man = "Add some control points with your mouse" + NL + "and drag them to deform the image." + NL + " " + NL + "ENTER - Apply the deformation." + NL + "ESC - Return to the original image." + NL + "U - Toggle mesh display.";
    private static int numX = 32;
    private static double alpha = 1.0;
    final int nD = 2;
    protected TransformMesh mesh;
    protected ThinPlateR2LogRSplineKernelTransform tps;
    protected double[][] sourceLandmarks;
    protected double[][] targetLandmarks;

    protected final void createMapping() {
        this.mapping = new TransformMeshMapping(this.mesh);
    }

    protected final void updateMapping() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.tps = new ThinPlateR2LogRSplineKernelTransform(2, this.sourceLandmarks, this.targetLandmarks);
        this.mesh.init((CoordinateTransform)new ThinPlateSplineTransform(this.tps));
        this.updateIllustration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addHandle(int x, int y) {
        double[] l = new double[]{x, y};
        TransformMesh transformMesh = this.mesh;
        synchronized (transformMesh) {
            try {
                this.mesh.applyInverseInPlace(l);
                Point here = new Point(l);
                Point there = new Point(l);
                this.hooks.add(here);
                here.apply((CoordinateTransform)this.mesh);
                this.m.add(new PointMatch(there, here, 10.0));
                int nL = 0;
                if (this.sourceLandmarks != null && this.sourceLandmarks.length > 0) {
                    nL = this.sourceLandmarks[0].length;
                }
                double[][] newsrc = new double[this.tps.getNumDims()][nL + 1];
                double[][] newtgt = new double[this.tps.getNumDims()][nL + 1];
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < nL; ++i) {
                        newsrc[j][i] = this.sourceLandmarks[j][i];
                        newtgt[j][i] = this.targetLandmarks[j][i];
                    }
                }
                newtgt[0][nL] = x;
                newtgt[1][nL] = y;
                newsrc[0][nL] = x;
                newsrc[1][nL] = y;
                this.sourceLandmarks = newsrc;
                this.targetLandmarks = newtgt;
            }
            catch (NoninvertibleModelException e) {
                e.printStackTrace();
            }
        }
    }

    protected final void updateHandles(int x, int y) {
        int nL = 0;
        if (this.sourceLandmarks != null && this.sourceLandmarks.length > 0) {
            nL = this.sourceLandmarks[0].length;
        }
        double[][] newsrc = new double[this.tps.getNumDims()][nL];
        double[][] newtgt = new double[this.tps.getNumDims()][nL];
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < nL; ++i) {
                newsrc[j][i] = this.sourceLandmarks[j][i];
                if (i == this.targetIndex) continue;
                newtgt[j][i] = this.targetLandmarks[j][i];
            }
        }
        newtgt[0][this.targetIndex] = x;
        newtgt[1][this.targetIndex] = y;
        this.sourceLandmarks = newsrc;
        this.targetLandmarks = newtgt;
    }

    public final void init() {
        GenericDialog gd = new GenericDialog("Thin Plate Spline Transform");
        gd.addNumericField("Vertices_per_row :", (double)numX, 0);
        gd.addNumericField("Alpha :", alpha, 2);
        gd.addCheckbox("_Interactive_preview", showPreview);
        gd.addMessage(man);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        numX = (int)gd.getNextNumber();
        alpha = gd.getNextNumber();
        showPreview = gd.getNextBoolean();
        this.tps = new ThinPlateR2LogRSplineKernelTransform(2);
        this.mesh = new TransformMesh(numX, (double)this.imp.getWidth(), (double)this.imp.getHeight());
    }

    protected final void updateIllustration() {
        if (showIllustration) {
            this.imp.setOverlay(this.mesh.illustrateMesh(), Color.white, null);
        } else {
            this.imp.setOverlay(null);
        }
    }
}

