/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility;

import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.transform.Transform;
import net.imglib2.transform.integer.shear.AbstractShearTransform;
import net.imglib2.transform.integer.shear.ShearTransform;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.TransformView;
import net.imglib2.view.Views;

public class MatrixStripConversion {
    public static <T extends RealType<T>> RandomAccessibleInterval<T> stripToMatrix(RandomAccessibleInterval<T> strip) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(strip)).createVariable();
        extension.setReal(Double.NaN);
        return MatrixStripConversion.stripToMatrix(strip, extension);
    }

    public static <T extends Type<T>> RandomAccessibleInterval<T> stripToMatrix(RandomAccessibleInterval<T> strip, T extension) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(strip, extension);
        AbstractShearTransform tf = new ShearTransform(2, 0, 1).inverse();
        long w = strip.dimension(0) / 2L;
        long h = strip.dimension(1);
        FinalInterval interval = new FinalInterval(new long[]{w, 0L}, new long[]{h + w - 1L, h - 1L});
        IntervalView transformed = Views.offsetInterval((RandomAccessible)new TransformView((RandomAccessible)extended, (Transform)tf), (Interval)interval);
        return transformed;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> matrixToStrip(RandomAccessibleInterval<T> matrix, int range) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(matrix)).createVariable();
        extension.setReal(Double.NaN);
        return MatrixStripConversion.matrixToStrip(matrix, range, extension);
    }

    public static <T extends Type<T>> RandomAccessibleInterval<T> matrixToStrip(RandomAccessibleInterval<T> matrix, int range, T extension) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(matrix, extension);
        ShearTransform tf = new ShearTransform(2, 0, 1);
        long h = matrix.dimension(1);
        FinalInterval interval = new FinalInterval(new long[]{-range, 0L}, new long[]{range, h - 1L});
        IntervalView transformed = Views.offsetInterval((RandomAccessible)new TransformView((RandomAccessible)extended, (Transform)tf), (Interval)interval);
        return transformed;
    }
}

