/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.rules.Rule;
import weka.classifiers.rules.RuleStats;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.ClassOrder;

public class JRip
extends AbstractClassifier
implements AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6589312996832147161L;
    private static double MAX_DL_SURPLUS = 64.0;
    private Attribute m_Class;
    private ArrayList<Rule> m_Ruleset;
    private ArrayList<double[]> m_Distributions;
    private int m_Optimizations = 2;
    private Random m_Random = null;
    private double m_Total = 0.0;
    private long m_Seed = 1L;
    private int m_Folds = 3;
    private double m_MinNo = 2.0;
    private boolean m_Debug = false;
    private boolean m_CheckErr = true;
    private boolean m_UsePruning = true;
    private Filter m_Filter = null;
    private ArrayList<RuleStats> m_RulesetStats;

    public String globalInfo() {
        return "This class implements a propositional rule learner, Repeated Incremental Pruning to Produce Error Reduction (RIPPER), which was proposed by William W. Cohen as an optimized version of IREP. \n\nThe algorithm is briefly described as follows: \n\nInitialize RS = {}, and for each class from the less prevalent one to the more frequent one, DO: \n\n1. Building stage:\nRepeat 1.1 and 1.2 until the descrition length (DL) of the ruleset and examples is 64 bits greater than the smallest DL met so far, or there are no positive examples, or the error rate >= 50%. \n\n1.1. Grow phase:\nGrow one rule by greedily adding antecedents (or conditions) to the rule until the rule is perfect (i.e. 100% accurate).  The procedure tries every possible value of each attribute and selects the condition with highest information gain: p(log(p/t)-log(P/T)).\n\n1.2. Prune phase:\nIncrementally prune each rule and allow the pruning of any final sequences of the antecedents;The pruning metric is (p-n)/(p+n) -- but it's actually 2p/(p+n) -1, so in this implementation we simply use p/(p+n) (actually (p+1)/(p+n+2), thus if p+n is 0, it's 0.5).\n\n2. Optimization stage:\n after generating the initial ruleset {Ri}, generate and prune two variants of each rule Ri from randomized data using procedure 1.1 and 1.2. But one variant is generated from an empty rule while the other is generated by greedily adding antecedents to the original rule. Moreover, the pruning metric used here is (TP+TN)/(P+N).Then the smallest possible DL for each variant and the original rule is computed.  The variant with the minimal DL is selected as the final representative of Ri in the ruleset.After all the rules in {Ri} have been examined and if there are still residual positives, more rules are generated based on the residual positives using Building Stage again. \n3. Delete the rules from the ruleset that would increase the DL of the whole ruleset if it were in it. and add resultant ruleset to RS. \nENDDO\n\nNote that there seem to be 2 bugs in the original ripper program that would affect the ruleset size and accuracy slightly.  This implementation avoids these bugs and thus is a little bit different from Cohen's original implementation. Even after fixing the bugs, since the order of classes with the same frequency is not defined in ripper, there still seems to be some trivial difference between this implementation and the original ripper, especially for audiology data in UCI repository, where there are lots of classes of few instances.\n\nDetails please see:\n\n" + this.getTechnicalInformation().toString() + "\n\nPS.  We have compared this implementation with the original ripper implementation in aspects of accuracy, ruleset size and running time on both artificial data \"ab+bcd+defg\" and UCI datasets.  In all these aspects it seems to be quite comparable to the original ripper implementation.  However, we didn't consider memory consumption optimization in this implementation.\n\n";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "William W. Cohen");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast Effective Rule Induction");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Twelfth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "115-123");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(7);
        newVector.add(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        newVector.add(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        newVector.add(new Option("\tSet the number of runs of\n\toptimizations. (Default: 2)", "O", 1, "-O <number of runs>"));
        newVector.add(new Option("\tSet whether turn on the\n\tdebug mode (Default: false)", "D", 0, "-D"));
        newVector.add(new Option("\tThe seed of randomization\n\t(Default: 1)", "S", 1, "-S <seed>"));
        newVector.add(new Option("\tWhether NOT check the error rate>=0.5\n\tin stopping criteria \t(default: check)", "E", 0, "-E"));
        newVector.add(new Option("\tWhether NOT use pruning\n\t(default: use pruning)", "P", 0, "-P"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString = Utils.getOption('F', options);
        this.m_Folds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String minNoString = Utils.getOption('N', options);
        this.m_MinNo = minNoString.length() != 0 ? Double.parseDouble(minNoString) : 2.0;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? Long.parseLong(seedString) : 1L;
        String runString = Utils.getOption('O', options);
        this.m_Optimizations = runString.length() != 0 ? Integer.parseInt(runString) : 2;
        this.m_Debug = Utils.getFlag('D', options);
        this.m_CheckErr = !Utils.getFlag('E', options);
        this.m_UsePruning = !Utils.getFlag('P', options);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-F");
        options.add("" + this.m_Folds);
        options.add("-N");
        options.add("" + this.m_MinNo);
        options.add("-O");
        options.add("" + this.m_Optimizations);
        options.add("-S");
        options.add("" + this.m_Seed);
        if (this.m_Debug) {
            options.add("-D");
        }
        if (!this.m_CheckErr) {
            options.add("-E");
        }
        if (!this.m_UsePruning) {
            options.add("-P");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.add("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (RIPPER)");
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int fold) {
        this.m_Folds = fold;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long s) {
        this.m_Seed = s;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return "The number of optimization runs.";
    }

    public void setOptimizations(int run) {
        this.m_Optimizations = run;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    @Override
    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    @Override
    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    @Override
    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return "Whether check for error rate >= 1/2 is included in stopping criterion.";
    }

    public void setCheckErrorRate(boolean d) {
        this.m_CheckErr = d;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String usePruningTipText() {
        return "Whether pruning is performed.";
    }

    public void setUsePruning(boolean d) {
        this.m_UsePruning = d;
    }

    public boolean getUsePruning() {
        return this.m_UsePruning;
    }

    public ArrayList<Rule> getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int pos) {
        return this.m_RulesetStats.get(pos);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(this.m_Folds);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Random = instances.getRandomNumberGenerator(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println("Number of all possible conditions = " + this.m_Total);
        }
        Instances data = null;
        this.m_Filter = new ClassOrder();
        ((ClassOrder)this.m_Filter).setSeed(this.m_Random.nextInt());
        ((ClassOrder)this.m_Filter).setClassOrder(0);
        this.m_Filter.setInputFormat(instances);
        data = Filter.useFilter(instances, this.m_Filter);
        if (data == null) {
            throw new Exception(" Unable to randomize the class orders.");
        }
        this.m_Class = data.classAttribute();
        this.m_Ruleset = new ArrayList();
        this.m_RulesetStats = new ArrayList();
        this.m_Distributions = new ArrayList();
        double[] orderedClasses = ((ClassOrder)this.m_Filter).getClassCounts();
        if (this.m_Debug) {
            System.err.println("Sorted classes:");
            for (int x = 0; x < this.m_Class.numValues(); ++x) {
                System.err.println(x + ": " + this.m_Class.value(x) + " has " + orderedClasses[x] + " instances.");
            }
        }
        for (int y = 0; y < data.numClasses() - 1; ++y) {
            double classIndex = y;
            if (this.m_Debug) {
                int ci = (int)classIndex;
                System.err.println("\n\nClass " + this.m_Class.value(ci) + "(" + ci + "): " + orderedClasses[y] + "instances\n=====================================\n");
            }
            if (Utils.eq(orderedClasses[y], 0.0)) continue;
            double all = 0.0;
            for (int i = y; i < orderedClasses.length; ++i) {
                all += orderedClasses[i];
            }
            double expFPRate = orderedClasses[y] / all;
            double classYWeights = 0.0;
            double totalWeights = 0.0;
            for (int j = 0; j < data.numInstances(); ++j) {
                Instance datum = data.instance(j);
                totalWeights += datum.weight();
                if ((int)datum.classValue() != y) continue;
                classYWeights += datum.weight();
            }
            if (!(classYWeights > 0.0)) continue;
            double defDL = RuleStats.dataDL(expFPRate, 0.0, totalWeights, 0.0, classYWeights);
            if (Double.isNaN(defDL) || Double.isInfinite(defDL)) {
                throw new Exception("Should never happen: defDL NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("The default DL = " + defDL);
            }
            data = this.rulesetForOneClass(expFPRate, data, classIndex, defDL);
        }
        for (Rule rule : this.m_Ruleset) {
            ((RipperRule)rule).cleanUp(data);
        }
        RipperRule defRule = new RipperRule();
        defRule.setConsequent(data.numClasses() - 1);
        this.m_Ruleset.add(defRule);
        RuleStats defRuleStat = new RuleStats();
        defRuleStat.setData(data);
        defRuleStat.setNumAllConds(this.m_Total);
        defRuleStat.addAndUpdate(defRule);
        this.m_RulesetStats.add(defRuleStat);
        for (int z = 0; z < this.m_RulesetStats.size(); ++z) {
            RuleStats oneClass = this.m_RulesetStats.get(z);
            for (int xyz = 0; xyz < oneClass.getRulesetSize(); ++xyz) {
                double[] classDist = oneClass.getDistributions(xyz);
                Utils.normalize(classDist);
                if (classDist == null) continue;
                this.m_Distributions.add(((ClassOrder)this.m_Filter).distributionsByOriginalIndex(classDist));
            }
        }
        for (int i = 0; i < this.m_RulesetStats.size(); ++i) {
            this.m_RulesetStats.get(i).cleanUp();
        }
    }

    @Override
    public double[] distributionForInstance(Instance datum) {
        try {
            for (int i = 0; i < this.m_Ruleset.size(); ++i) {
                Rule rule = this.m_Ruleset.get(i);
                if (!rule.covers(datum)) continue;
                return this.m_Distributions.get(i);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        System.err.println("Should never happen!");
        return new double[datum.classAttribute().numValues()];
    }

    protected Instances rulesetForOneClass(double expFPRate, Instances data, double classIndex, double defDL) throws Exception {
        double[] rst;
        Instances pruneData;
        Instances growData;
        boolean defHasPositive;
        Instances newData = data;
        boolean stop = false;
        ArrayList<Object> ruleset = new ArrayList();
        double dl = defDL;
        double minDL = defDL;
        RuleStats rstats = null;
        boolean hasPositive = defHasPositive = true;
        if (this.m_Debug) {
            System.err.println("\n*** Building stage ***");
        }
        while (!stop && hasPositive) {
            RipperRule oneRule;
            if (this.m_UsePruning) {
                newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                Instances[] part = RuleStats.partition(newData, this.m_Folds);
                growData = part[0];
                pruneData = part[1];
                oneRule = new RipperRule();
                oneRule.setConsequent(classIndex);
                if (this.m_Debug) {
                    System.err.println("\nGrowing a rule ...");
                }
                oneRule.grow(growData);
                if (this.m_Debug) {
                    System.err.println("One rule found before pruning:" + oneRule.toString(this.m_Class));
                }
                if (this.m_Debug) {
                    System.err.println("\nPruning the rule ...");
                }
                oneRule.prune(pruneData, false);
                if (this.m_Debug) {
                    System.err.println("One rule found after pruning:" + oneRule.toString(this.m_Class));
                }
            } else {
                oneRule = new RipperRule();
                oneRule.setConsequent(classIndex);
                if (this.m_Debug) {
                    System.err.println("\nNo pruning: growing a rule ...");
                }
                oneRule.grow(newData);
                if (this.m_Debug) {
                    System.err.println("No pruning: one rule found:\n" + oneRule.toString(this.m_Class));
                }
            }
            if (rstats == null) {
                rstats = new RuleStats();
                rstats.setNumAllConds(this.m_Total);
                rstats.setData(newData);
            }
            rstats.addAndUpdate(oneRule);
            int last = rstats.getRuleset().size() - 1;
            if (Double.isNaN(dl += rstats.relativeDL(last, expFPRate, this.m_CheckErr)) || Double.isInfinite(dl)) {
                throw new Exception("Should never happen: dl in building stage NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("Before optimization(" + last + "): the dl = " + dl + " | best: " + minDL);
            }
            if (dl < minDL) {
                minDL = dl;
            }
            rst = rstats.getSimpleStats(last);
            if (this.m_Debug) {
                System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
            }
            if (!(stop = this.checkStop(rst, minDL, dl))) {
                ruleset.add(oneRule);
                newData = rstats.getFiltered(last)[1];
                hasPositive = Utils.gr(rst[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println("One rule added: has positive? " + hasPositive);
                continue;
            }
            if (this.m_Debug) {
                System.err.println("Quit rule");
            }
            rstats.removeLast();
        }
        RuleStats finalRulesetStat = null;
        if (this.m_UsePruning) {
            for (int z = 0; z < this.m_Optimizations; ++z) {
                if (this.m_Debug) {
                    System.err.println("\n*** Optimization: run #" + z + " ***");
                }
                newData = data;
                finalRulesetStat = new RuleStats();
                finalRulesetStat.setData(newData);
                finalRulesetStat.setNumAllConds(this.m_Total);
                int position = 0;
                stop = false;
                boolean isResidual = false;
                hasPositive = defHasPositive;
                dl = minDL = defDL;
                while (!stop && hasPositive) {
                    RipperRule finalRule;
                    isResidual = position >= ruleset.size();
                    newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                    Instances[] part = RuleStats.partition(newData, this.m_Folds);
                    growData = part[0];
                    pruneData = part[1];
                    if (this.m_Debug) {
                        System.err.println("\nRule #" + position + "| isResidual?" + isResidual + "| data size: " + newData.sumOfWeights());
                    }
                    if (isResidual) {
                        RipperRule newRule = new RipperRule();
                        newRule.setConsequent(classIndex);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning a new rule ...");
                        }
                        newRule.grow(growData);
                        newRule.prune(pruneData, false);
                        finalRule = newRule;
                        if (this.m_Debug) {
                            System.err.println("\nNew rule found: " + newRule.toString(this.m_Class));
                        }
                    } else {
                        RipperRule oldRule = (RipperRule)ruleset.get(position);
                        boolean covers = false;
                        for (int i = 0; i < newData.numInstances(); ++i) {
                            if (!oldRule.covers(newData.instance(i))) continue;
                            covers = true;
                            break;
                        }
                        if (!covers) {
                            finalRulesetStat.addAndUpdate(oldRule);
                            ++position;
                            continue;
                        }
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Replace ...");
                        }
                        RipperRule replace = new RipperRule();
                        replace.setConsequent(classIndex);
                        replace.grow(growData);
                        pruneData = RuleStats.rmCoveredBySuccessives(pruneData, ruleset, position);
                        replace.prune(pruneData, true);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Revision ...");
                        }
                        RipperRule revision = (RipperRule)oldRule.copy();
                        Instances newGrowData = new Instances(growData, 0);
                        for (int b = 0; b < growData.numInstances(); ++b) {
                            Instance inst = growData.instance(b);
                            if (!revision.covers(inst)) continue;
                            newGrowData.add(inst);
                        }
                        revision.grow(newGrowData);
                        revision.prune(pruneData, true);
                        double[][] prevRuleStats = new double[position][6];
                        for (int c = 0; c < position; ++c) {
                            prevRuleStats[c] = finalRulesetStat.getSimpleStats(c);
                        }
                        ArrayList<Rule> tempRules = new ArrayList<Rule>(ruleset.size());
                        for (Rule rule : ruleset) {
                            tempRules.add((Rule)rule.copy());
                        }
                        tempRules.set(position, replace);
                        RuleStats repStat = new RuleStats(data, tempRules);
                        repStat.setNumAllConds(this.m_Total);
                        repStat.countData(position, newData, prevRuleStats);
                        rst = repStat.getSimpleStats(position);
                        if (this.m_Debug) {
                            System.err.println("Replace rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                        }
                        double d = repStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("\nReplace: " + replace.toString(this.m_Class) + " |dl = " + d);
                        }
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            throw new Exception("Should never happen: repDLin optmz. stage NaN or infinite!");
                        }
                        tempRules.set(position, revision);
                        RuleStats revStat = new RuleStats(data, tempRules);
                        revStat.setNumAllConds(this.m_Total);
                        revStat.countData(position, newData, prevRuleStats);
                        double revDL = revStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("Revision: " + revision.toString(this.m_Class) + " |dl = " + revDL);
                        }
                        if (Double.isNaN(revDL) || Double.isInfinite(revDL)) {
                            throw new Exception("Should never happen: revDLin optmz. stage NaN or infinite!");
                        }
                        rstats = new RuleStats(data, ruleset);
                        rstats.setNumAllConds(this.m_Total);
                        rstats.countData(position, newData, prevRuleStats);
                        double oldDL = rstats.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (Double.isNaN(oldDL) || Double.isInfinite(oldDL)) {
                            throw new Exception("Should never happen: oldDLin optmz. stage NaN or infinite!");
                        }
                        if (this.m_Debug) {
                            System.err.println("Old rule: " + oldRule.toString(this.m_Class) + " |dl = " + oldDL);
                        }
                        if (this.m_Debug) {
                            System.err.println("\nrepDL: " + d + "\nrevDL: " + revDL + "\noldDL: " + oldDL);
                        }
                        finalRule = oldDL <= revDL && oldDL <= d ? oldRule : (revDL <= d ? revision : replace);
                    }
                    finalRulesetStat.addAndUpdate(finalRule);
                    rst = finalRulesetStat.getSimpleStats(position);
                    if (isResidual) {
                        dl += finalRulesetStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("After optimization: the dl=" + dl + " | best: " + minDL);
                        }
                        if (dl < minDL) {
                            minDL = dl;
                        }
                        if (!(stop = this.checkStop(rst, minDL, dl))) {
                            ruleset.add(finalRule);
                        } else {
                            finalRulesetStat.removeLast();
                            --position;
                        }
                    } else {
                        ruleset.set(position, finalRule);
                    }
                    if (this.m_Debug) {
                        System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                        System.err.println("\nRuleset so far: ");
                        for (int x = 0; x < ruleset.size(); ++x) {
                            System.err.println(x + ": " + ((RipperRule)ruleset.get(x)).toString(this.m_Class));
                        }
                        System.err.println();
                    }
                    if (finalRulesetStat.getRulesetSize() > 0) {
                        newData = finalRulesetStat.getFiltered(position)[1];
                    }
                    hasPositive = Utils.gr(rst[5], 0.0);
                    ++position;
                }
                if (ruleset.size() > position + 1) {
                    for (int k = position + 1; k < ruleset.size(); ++k) {
                        finalRulesetStat.addAndUpdate((Rule)ruleset.get(k));
                    }
                }
                if (this.m_Debug) {
                    System.err.println("\nDeleting rules to decrease DL of the whole ruleset ...");
                }
                finalRulesetStat.reduceDL(expFPRate, this.m_CheckErr);
                if (this.m_Debug) {
                    int del = ruleset.size() - finalRulesetStat.getRulesetSize();
                    System.err.println(del + " rules are deleted after DL reduction procedure");
                }
                ruleset = finalRulesetStat.getRuleset();
                rstats = finalRulesetStat;
            }
        }
        if (this.m_Debug) {
            System.err.println("\nFinal ruleset: ");
            for (int x = 0; x < ruleset.size(); ++x) {
                System.err.println(x + ": " + ((RipperRule)ruleset.get(x)).toString(this.m_Class));
            }
            System.err.println();
        }
        this.m_Ruleset.addAll(ruleset);
        this.m_RulesetStats.add(rstats);
        if (ruleset.size() > 0) {
            return rstats.getFiltered(ruleset.size() - 1)[1];
        }
        return data;
    }

    private boolean checkStop(double[] rst, double minDL, double dl) {
        if (dl > minDL + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println("DL too large: " + dl + " | " + minDL);
            }
            return true;
        }
        if (!Utils.gr(rst[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println("Too few positives.");
            }
            return true;
        }
        if (rst[4] / rst[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println("Error too large: " + rst[4] + "/" + rst[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println("Continue.");
        }
        return false;
    }

    public String toString() {
        if (this.m_Ruleset == null) {
            return "JRIP: No model built yet.";
        }
        StringBuffer sb = new StringBuffer("JRIP rules:\n===========\n\n");
        for (int j = 0; j < this.m_RulesetStats.size(); ++j) {
            RuleStats rs = this.m_RulesetStats.get(j);
            ArrayList<Rule> rules = rs.getRuleset();
            for (int k = 0; k < rules.size(); ++k) {
                double[] simStats = rs.getSimpleStats(k);
                sb.append(((RipperRule)rules.get(k)).toString(this.m_Class) + " (" + simStats[0] + "/" + simStats[4] + ")\n");
            }
        }
        if (this.m_Debug) {
            System.err.println("Inside m_Ruleset");
            for (int i = 0; i < this.m_Ruleset.size(); ++i) {
                System.err.println(((RipperRule)this.m_Ruleset.get(i)).toString(this.m_Class));
            }
        }
        sb.append("\nNumber of Rules : " + this.m_Ruleset.size() + "\n");
        return sb.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15519 $");
    }

    public static void main(String[] args) {
        JRip.runClassifier(new JRip(), args);
    }

    public class RipperRule
    extends Rule {
        static final long serialVersionUID = -2410020717305262952L;
        private double m_Consequent = -1.0;
        protected ArrayList<Antd> m_Antds = new ArrayList();

        public void cleanUp(Instances data) {
            int i;
            double[] mins = new double[data.numAttributes()];
            double[] maxs = new double[data.numAttributes()];
            for (i = 0; i < data.numAttributes(); ++i) {
                mins[i] = Double.MAX_VALUE;
                maxs[i] = -1.7976931348623157E308;
            }
            for (i = this.m_Antds.size() - 1; i >= 0; --i) {
                Attribute att = this.m_Antds.get(i).getAttr();
                if (!att.isNumeric()) continue;
                double splitPoint = ((NumericAntd)this.m_Antds.get(i)).getSplitPoint();
                if (this.m_Antds.get(i).getAttrValue() == 0.0) {
                    if (splitPoint < mins[att.index()]) {
                        mins[att.index()] = splitPoint;
                        continue;
                    }
                    this.m_Antds.remove(i);
                    continue;
                }
                if (splitPoint > maxs[att.index()]) {
                    maxs[att.index()] = splitPoint;
                    continue;
                }
                this.m_Antds.remove(i);
            }
        }

        public void setConsequent(double cl) {
            this.m_Consequent = cl;
        }

        @Override
        public double getConsequent() {
            return this.m_Consequent;
        }

        @Override
        public Object copy() {
            RipperRule copy = new RipperRule();
            copy.setConsequent(this.getConsequent());
            copy.m_Antds = new ArrayList(this.m_Antds.size());
            for (Antd a : this.m_Antds) {
                copy.m_Antds.add((Antd)a.copy());
            }
            return copy;
        }

        @Override
        public boolean covers(Instance datum) {
            boolean isCover = true;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = this.m_Antds.get(i);
                if (antd.covers(datum)) continue;
                isCover = false;
                break;
            }
            return isCover;
        }

        @Override
        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        public ArrayList<Antd> getAntds() {
            return this.m_Antds;
        }

        @Override
        public double size() {
            return this.m_Antds.size();
        }

        private double computeDefAccu(Instances data) {
            double defAccu = 0.0;
            for (int i = 0; i < data.numInstances(); ++i) {
                Instance inst = data.instance(i);
                if ((int)inst.classValue() != (int)this.m_Consequent) continue;
                defAccu += inst.weight();
            }
            return defAccu;
        }

        @Override
        public void grow(Instances data) throws Exception {
            if (this.m_Consequent == -1.0) {
                throw new Exception(" Consequent not set yet.");
            }
            Instances growData = data;
            double sumOfWeights = growData.sumOfWeights();
            if (!Utils.gr(sumOfWeights, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(growData);
            double defAcRt = (defAccu + 1.0) / (sumOfWeights + 1.0);
            boolean[] used = new boolean[growData.numAttributes()];
            for (int k = 0; k < used.length; ++k) {
                used[k] = false;
            }
            int numUnused = used.length;
            for (int j = 0; j < this.m_Antds.size(); ++j) {
                Antd antdj = this.m_Antds.get(j);
                if (antdj.getAttr().isNumeric()) continue;
                used[antdj.getAttr().index()] = true;
                --numUnused;
            }
            while (Utils.gr(growData.numInstances(), 0.0) && numUnused > 0 && Utils.sm(defAcRt, 1.0)) {
                double maxInfoGain = 0.0;
                Antd oneAntd = null;
                Instances coverData = null;
                Enumeration<Attribute> enumAttr = growData.enumerateAttributes();
                while (enumAttr.hasMoreElements()) {
                    Instances coveredData;
                    Attribute att = enumAttr.nextElement();
                    if (JRip.this.m_Debug) {
                        System.err.println("\nOne condition: size = " + growData.sumOfWeights());
                    }
                    Antd antd = null;
                    antd = att.isNumeric() ? new NumericAntd(att) : new NominalAntd(att);
                    if (used[att.index()] || (coveredData = this.computeInfoGain(growData, defAcRt, antd)) == null) continue;
                    double infoGain = antd.getMaxInfoGain();
                    if (JRip.this.m_Debug) {
                        System.err.println("Test of '" + antd.toString() + "': infoGain = " + infoGain + " | Accuracy = " + antd.getAccuRate() + "=" + antd.getAccu() + "/" + antd.getCover() + " def. accuracy: " + defAcRt);
                    }
                    if (!(infoGain > maxInfoGain)) continue;
                    oneAntd = antd;
                    coverData = coveredData;
                    maxInfoGain = infoGain;
                }
                if (oneAntd == null || Utils.sm(oneAntd.getAccu(), JRip.this.m_MinNo)) break;
                if (!oneAntd.getAttr().isNumeric()) {
                    used[oneAntd.getAttr().index()] = true;
                    --numUnused;
                }
                this.m_Antds.add(oneAntd);
                growData = coverData;
                defAcRt = oneAntd.getAccuRate();
            }
        }

        private Instances computeInfoGain(Instances instances, double defAcRt, Antd antd) {
            Instances data = instances;
            Instances[] splitData = antd.splitData(data, defAcRt, this.m_Consequent);
            if (splitData != null) {
                return splitData[(int)antd.getAttrValue()];
            }
            return null;
        }

        public void prune(Instances pruneData, boolean useWhole) {
            int size;
            Instances data = pruneData;
            double total = data.sumOfWeights();
            if (!Utils.gr(total, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(data);
            if (JRip.this.m_Debug) {
                System.err.println("Pruning with " + defAccu + " positive data out of " + total + " instances");
            }
            if ((size = this.m_Antds.size()) == 0) {
                return;
            }
            double[] worthRt = new double[size];
            double[] coverage = new double[size];
            double[] worthValue = new double[size];
            for (int w = 0; w < size; ++w) {
                worthValue[w] = 0.0;
                coverage[w] = 0.0;
                worthRt[w] = 0.0;
            }
            double tn = 0.0;
            for (int x = 0; x < size; ++x) {
                Antd antd = this.m_Antds.get(x);
                Instances newData = data;
                data = new Instances(newData, 0);
                for (int y = 0; y < newData.numInstances(); ++y) {
                    Instance ins = newData.instance(y);
                    if (antd.covers(ins)) {
                        int n = x;
                        coverage[n] = coverage[n] + ins.weight();
                        data.add(ins);
                        if ((int)ins.classValue() != (int)this.m_Consequent) continue;
                        int n2 = x;
                        worthValue[n2] = worthValue[n2] + ins.weight();
                        continue;
                    }
                    if (!useWhole || (int)ins.classValue() == (int)this.m_Consequent) continue;
                    tn += ins.weight();
                }
                if (useWhole) {
                    int n = x;
                    worthValue[n] = worthValue[n] + tn;
                    worthRt[x] = worthValue[x] / total;
                    continue;
                }
                worthRt[x] = (worthValue[x] + 1.0) / (coverage[x] + 2.0);
            }
            double maxValue = (defAccu + 1.0) / (total + 2.0);
            int maxIndex = -1;
            for (int i = 0; i < worthValue.length; ++i) {
                if (JRip.this.m_Debug) {
                    double denom = useWhole ? total : coverage[i];
                    System.err.println(i + "(useAccuray? " + !useWhole + "): " + worthRt[i] + "=" + worthValue[i] + "/" + denom);
                }
                if (!(worthRt[i] > maxValue)) continue;
                maxValue = worthRt[i];
                maxIndex = i;
            }
            for (int z = size - 1; z > maxIndex; --z) {
                this.m_Antds.remove(z);
            }
        }

        public String toString(Attribute classAttr) {
            StringBuffer text = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int j = 0; j < this.m_Antds.size() - 1; ++j) {
                    text.append("(" + this.m_Antds.get(j).toString() + ") and ");
                }
                text.append("(" + this.m_Antds.get(this.m_Antds.size() - 1).toString() + ")");
            }
            text.append(" => " + classAttr.name() + "=" + classAttr.value((int)this.m_Consequent));
            return text.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15519 $");
        }
    }

    public class NominalAntd
    extends Antd {
        static final long serialVersionUID = -9102297038837585135L;
        private final double[] accurate;
        private final double[] coverage;

        public NominalAntd(Attribute a) {
            super(a);
            int bag = this.att.numValues();
            this.accurate = new double[bag];
            this.coverage = new double[bag];
        }

        @Override
        public Object copy() {
            NominalAntd antec = new NominalAntd(this.getAttr());
            antec.value = this.value;
            return antec;
        }

        @Override
        public Instances[] splitData(Instances data, double defAcRt, double cl) {
            int x;
            int bag = this.att.numValues();
            Instances[] splitData = new Instances[bag];
            for (x = 0; x < bag; ++x) {
                splitData[x] = new Instances(data, data.numInstances());
                this.accurate[x] = 0.0;
                this.coverage[x] = 0.0;
            }
            for (x = 0; x < data.numInstances(); ++x) {
                Instance inst = data.instance(x);
                if (inst.isMissing(this.att)) continue;
                int v = (int)inst.value(this.att);
                splitData[v].add(inst);
                int n = v;
                this.coverage[n] = this.coverage[n] + inst.weight();
                if ((int)inst.classValue() != (int)cl) continue;
                int n2 = v;
                this.accurate[n2] = this.accurate[n2] + inst.weight();
            }
            for (x = 0; x < bag; ++x) {
                double p = this.accurate[x] + 1.0;
                double t = this.coverage[x] + 1.0;
                double infoGain = this.accurate[x] * (Utils.log2(p / t) - Utils.log2(defAcRt));
                if (!(infoGain > this.maxInfoGain)) continue;
                this.maxInfoGain = infoGain;
                this.cover = this.coverage[x];
                this.accu = this.accurate[x];
                this.accuRate = p / t;
                this.value = x;
            }
            return splitData;
        }

        @Override
        public boolean covers(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att) && (int)inst.value(this.att) == (int)this.value) {
                isCover = true;
            }
            return isCover;
        }

        @Override
        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15519 $");
        }
    }

    public class NumericAntd
    extends Antd {
        static final long serialVersionUID = 5699457269983735442L;
        private double splitPoint;

        public NumericAntd(Attribute a) {
            super(a);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        @Override
        public Object copy() {
            NumericAntd na = new NumericAntd(this.getAttr());
            na.value = this.value;
            na.splitPoint = this.splitPoint;
            return na;
        }

        @Override
        public Instances[] splitData(Instances insts, double defAcRt, double cl) {
            Instance inst;
            Instances data = insts;
            int total = data.numInstances();
            int split = 1;
            int prev = 0;
            int finalSplit = split;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double fstCover = 0.0;
            double sndCover = 0.0;
            double fstAccu = 0.0;
            double sndAccu = 0.0;
            data.sort(this.att);
            for (int x = 0; x < data.numInstances(); ++x) {
                inst = data.instance(x);
                if (inst.isMissing(this.att)) {
                    total = x;
                    break;
                }
                sndCover += inst.weight();
                if (!Utils.eq(inst.classValue(), cl)) continue;
                sndAccu += inst.weight();
            }
            if (total == 0) {
                return null;
            }
            this.splitPoint = data.instance(total - 1).value(this.att);
            while (split <= total) {
                if (split == total || data.instance(split).value(this.att) > data.instance(prev).value(this.att)) {
                    double coverage;
                    double accurate;
                    double accRate;
                    double infoGain;
                    boolean isFirst;
                    double sndInfoGain;
                    for (int y = prev; y < split; ++y) {
                        inst = data.instance(y);
                        fstCover += inst.weight();
                        if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                        fstAccu += inst.weight();
                    }
                    double fstAccuRate = (fstAccu + 1.0) / (fstCover + 1.0);
                    double sndAccuRate = (sndAccu + 1.0) / (sndCover + 1.0);
                    double fstInfoGain = fstAccu * (Utils.log2(fstAccuRate) - Utils.log2(defAcRt));
                    if (fstInfoGain > (sndInfoGain = sndAccu * (Utils.log2(sndAccuRate) - Utils.log2(defAcRt)))) {
                        isFirst = true;
                        infoGain = fstInfoGain;
                        accRate = fstAccuRate;
                        accurate = fstAccu;
                        coverage = fstCover;
                    } else {
                        isFirst = false;
                        infoGain = sndInfoGain;
                        accRate = sndAccuRate;
                        accurate = sndAccu;
                        coverage = sndCover;
                    }
                    if (infoGain > this.maxInfoGain) {
                        this.splitPoint = data.instance(prev).value(this.att);
                        this.value = isFirst ? 0.0 : 1.0;
                        this.accuRate = accRate;
                        this.accu = accurate;
                        this.cover = coverage;
                        this.maxInfoGain = infoGain;
                        finalSplit = isFirst ? split : prev;
                    }
                    for (int y = prev; y < split; ++y) {
                        Instance inst2 = data.instance(y);
                        sndCover -= inst2.weight();
                        if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                        sndAccu -= inst2.weight();
                    }
                    prev = split;
                }
                ++split;
            }
            Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit)};
            return splitData;
        }

        @Override
        public boolean covers(Instance inst) {
            boolean isCover = true;
            if (!inst.isMissing(this.att)) {
                if ((int)this.value == 0) {
                    if (inst.value(this.att) > this.splitPoint) {
                        isCover = false;
                    }
                } else if (inst.value(this.att) < this.splitPoint) {
                    isCover = false;
                }
            } else {
                isCover = false;
            }
            return isCover;
        }

        @Override
        public String toString() {
            String symbol = (int)this.value == 0 ? " <= " : " >= ";
            return this.att.name() + symbol + Utils.doubleToString(this.splitPoint, 6);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15519 $");
        }
    }

    public abstract class Antd
    implements WeightedInstancesHandler,
    Copyable,
    Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8929754772994154334L;
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute a) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean covers(Instance var1);

        public abstract String toString();

        @Override
        public abstract Object copy();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15519 $");
        }
    }
}

