/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.edges;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.edges.AbstractEdgeAnalyzer;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

@Plugin(type=EdgeAnalyzer.class)
public class EdgeSpeedAnalyzer
extends AbstractEdgeAnalyzer {
    public static final String KEY = "Edge speed";
    public static final String SPEED = "SPEED";
    public static final String DISPLACEMENT = "DISPLACEMENT";
    public static final List<String> FEATURES = new ArrayList<String>(2);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(2);
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(2);
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(2);
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(2);

    public EdgeSpeedAnalyzer() {
        super(KEY, KEY, FEATURES, FEATURE_NAMES, FEATURE_SHORT_NAMES, FEATURE_DIMENSIONS, IS_INT);
    }

    @Override
    protected void analyze(DefaultWeightedEdge edge, Model model) {
        FeatureModel featureModel = model.getFeatureModel();
        Spot source = model.getTrackModel().getEdgeSource(edge);
        Spot target = model.getTrackModel().getEdgeTarget(edge);
        double dx = target.diffTo(source, "POSITION_X");
        double dy = target.diffTo(source, "POSITION_Y");
        double dz = target.diffTo(source, "POSITION_Z");
        double dt = target.diffTo(source, "POSITION_T");
        double D = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double S = D / Math.abs(dt);
        featureModel.putEdgeFeature(edge, SPEED, S);
        featureModel.putEdgeFeature(edge, DISPLACEMENT, D);
    }

    static {
        FEATURES.add(SPEED);
        FEATURES.add(DISPLACEMENT);
        FEATURE_NAMES.put(SPEED, "Speed");
        FEATURE_NAMES.put(DISPLACEMENT, "Displacement");
        FEATURE_SHORT_NAMES.put(SPEED, "Speed");
        FEATURE_SHORT_NAMES.put(DISPLACEMENT, "Disp.");
        FEATURE_DIMENSIONS.put(SPEED, Dimension.VELOCITY);
        FEATURE_DIMENSIONS.put(DISPLACEMENT, Dimension.LENGTH);
        IS_INT.put(SPEED, Boolean.FALSE);
        IS_INT.put(DISPLACEMENT, Boolean.FALSE);
    }
}

