/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.GlasbeyLut;
import fiji.plugin.trackmate.visualization.TrackColorGenerator;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class PerTrackFeatureColorGenerator
implements TrackColorGenerator {
    private Map<Integer, Color> colorIndex;
    private final Model model;
    private final String feature;
    private final Colormap cmap;
    private final Color missingValueColor;

    public PerTrackFeatureColorGenerator(Model model, String trackFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.feature = trackFeature;
        this.missingValueColor = missingValueColor;
        this.cmap = colormap;
        this.colorIndex = new HashMap<Integer, Color>();
        TrackModel trackModel = model.getTrackModel();
        Set<Integer> trackIDs = trackModel.trackIDs(true);
        if (this.feature.equals("TRACK_INDEX")) {
            GlasbeyLut.reset();
            for (Integer trackID : trackIDs) {
                this.colorIndex.put(trackID, GlasbeyLut.next());
            }
        } else {
            FeatureModel fm = model.getFeatureModel();
            this.colorIndex = new HashMap<Integer, Color>(trackIDs.size());
            for (Integer trackID : trackIDs) {
                Double val = fm.getTrackFeature(trackID, this.feature);
                Color col = null == val ? missingValueColor : (val.isNaN() ? undefinedValueColor : this.cmap.getPaint((val - min) / (max - min)));
                this.colorIndex.put(trackID, col);
            }
        }
    }

    public Color colorOf(Integer trackID) {
        return this.colorIndex.get(trackID);
    }

    @Override
    public Color color(DefaultWeightedEdge edge) {
        Integer id = this.model.getTrackModel().trackIDOf(edge);
        if (id == null) {
            return this.missingValueColor;
        }
        return this.colorIndex.get(id);
    }
}

