/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apposed.appose.Builder;
import org.apposed.appose.Environment;
import org.apposed.appose.Scheme;
import org.apposed.appose.scheme.Schemes;
import org.apposed.appose.util.Environments;
import org.apposed.appose.util.FilePaths;

public abstract class BaseBuilder<T extends BaseBuilder<T>>
implements Builder<T> {
    public final List<Builder.ProgressConsumer> progressSubscribers = new ArrayList<Builder.ProgressConsumer>();
    public final List<Consumer<String>> outputSubscribers = new ArrayList<Consumer<String>>();
    public final List<Consumer<String>> errorSubscribers = new ArrayList<Consumer<String>>();
    public final Map<String, String> envVars = new HashMap<String, String>();
    public final List<String> channels = new ArrayList<String>();
    public final List<String> flags = new ArrayList<String>();
    protected String envName;
    protected File envDir;
    protected String sourceContent;
    protected String scheme;

    @Override
    public void delete() throws IOException {
        File dir = this.envDir();
        if (dir.exists()) {
            FilePaths.deleteRecursively(dir);
        }
    }

    @Override
    public Environment wrap(File envDir) throws IOException {
        FilePaths.ensureDirectory(envDir);
        this.base(envDir);
        return this.build();
    }

    @Override
    public T env(String key, String value) {
        this.envVars.put(key, value);
        return this.typedThis();
    }

    @Override
    public T env(Map<String, String> vars) {
        this.envVars.putAll(vars);
        return this.typedThis();
    }

    @Override
    public T name(String envName) {
        this.envName = envName;
        return this.typedThis();
    }

    @Override
    public T base(File envDir) {
        this.envDir = envDir;
        return this.typedThis();
    }

    @Override
    public T channels(List<String> channels) {
        this.channels.addAll(channels);
        return this.typedThis();
    }

    @Override
    public T flags(List<String> flags) {
        this.flags.addAll(flags);
        return this.typedThis();
    }

    @Override
    public T content(String content) {
        this.sourceContent = content;
        return this.typedThis();
    }

    @Override
    public T scheme(String scheme) {
        this.scheme = scheme;
        return this.typedThis();
    }

    @Override
    public T subscribeProgress(Builder.ProgressConsumer subscriber) {
        this.progressSubscribers.add(subscriber);
        return this.typedThis();
    }

    @Override
    public T subscribeOutput(Consumer<String> subscriber) {
        this.outputSubscribers.add(subscriber);
        return this.typedThis();
    }

    @Override
    public T subscribeError(Consumer<String> subscriber) {
        this.errorSubscribers.add(subscriber);
        return this.typedThis();
    }

    private T typedThis() {
        return (T)this;
    }

    protected String envName() {
        return this.envName != null ? this.envName : this.scheme().envName(this.sourceContent);
    }

    protected File envDir() {
        if (this.envDir != null) {
            return this.envDir;
        }
        return Paths.get(Environments.apposeEnvsDir(), this.envName()).toFile();
    }

    protected Scheme scheme() {
        return this.scheme != null ? Schemes.fromName(this.scheme) : Schemes.fromContent(this.sourceContent);
    }
}

