/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apposed.appose.util.Downloads;
import org.apposed.appose.util.Platforms;
import org.apposed.appose.util.Processes;

public abstract class Tool {
    protected final String name;
    protected final String url;
    protected final String command;
    protected final String rootdir;
    protected Consumer<String> outputConsumer;
    protected Consumer<String> errorConsumer;
    protected BiConsumer<Long, Long> downloadProgressConsumer;
    protected Map<String, String> envVars = new HashMap<String, String>();
    protected List<String> flags = new ArrayList<String>();
    private final StringBuilder capturedOutput = new StringBuilder();
    private final StringBuilder capturedError = new StringBuilder();

    public Tool(String name, String url, String command, String rootdir) {
        this.name = name;
        this.url = url;
        this.command = command;
        this.rootdir = rootdir;
    }

    public void setOutputConsumer(Consumer<String> consumer) {
        this.outputConsumer = consumer;
    }

    public void setErrorConsumer(Consumer<String> consumer) {
        this.errorConsumer = consumer;
    }

    public void setDownloadProgressConsumer(BiConsumer<Long, Long> consumer) {
        this.downloadProgressConsumer = consumer;
    }

    public void setEnvVars(Map<String, String> envVars) {
        if (envVars != null) {
            this.envVars = new HashMap<String, String>(envVars);
        }
    }

    public void setFlags(List<String> flags) {
        if (flags != null) {
            this.flags = new ArrayList<String>(flags);
        }
    }

    abstract String version() throws IOException, InterruptedException;

    public void install() throws IOException, InterruptedException, URISyntaxException {
        if (this.isInstalled()) {
            return;
        }
        this.decompress(this.download());
    }

    public boolean isInstalled() {
        try {
            this.version();
            return true;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    protected void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException(this.name + " is not installed");
        }
    }

    protected File download() throws IOException, InterruptedException, URISyntaxException {
        return Downloads.download(this.name, this.url, this::updateDownloadProgress);
    }

    protected abstract void decompress(File var1) throws IOException, InterruptedException;

    protected ProcessBuilder processBuilder(String cwd, boolean isInheritIO) {
        return Processes.builder(new File(cwd), this.envVars, isInheritIO, new String[0]);
    }

    protected void exec(String ... args) throws IOException, InterruptedException {
        this.checkInstalled();
        this.capturedOutput.setLength(0);
        this.capturedError.setLength(0);
        List<String> cmd = Platforms.baseCommand();
        cmd.add(this.command);
        cmd.addAll(this.flags);
        cmd.addAll(Arrays.asList(args));
        ProcessBuilder builder = this.processBuilder(this.rootdir, false);
        builder.command(cmd);
        Process process = builder.start();
        Thread mainThread = Thread.currentThread();
        Thread outputThread = new Thread(() -> {
            try {
                this.readStreams(process, mainThread);
            }
            catch (IOException | InterruptedException e) {
                this.error("Error reading streams: " + e.getMessage());
            }
        });
        outputThread.start();
        int exitCode = process.waitFor();
        outputThread.join();
        if (exitCode != 0) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(this.name).append(" command failed with exit code ").append(exitCode);
            errorMsg.append(": ").append(String.join((CharSequence)" ", args));
            String stderr = this.capturedError.toString().trim();
            if (!stderr.isEmpty()) {
                errorMsg.append("\n\nError output:\n").append(stderr);
            }
            String stdout = this.capturedOutput.toString().trim();
            if (stderr.isEmpty() && !stdout.isEmpty()) {
                errorMsg.append("\n\nOutput:\n").append(stdout);
            }
            throw new IOException(errorMsg.toString());
        }
    }

    protected void output(String line) {
        if (line != null && !line.isEmpty()) {
            this.capturedOutput.append(line);
            if (this.outputConsumer != null) {
                this.outputConsumer.accept(line);
            }
        }
    }

    protected void error(String line) {
        if (line != null && !line.isEmpty()) {
            this.capturedError.append(line);
            if (this.errorConsumer != null) {
                this.errorConsumer.accept(line);
            }
        }
    }

    protected void updateDownloadProgress(long current, long total) {
        if (this.downloadProgressConsumer != null) {
            this.downloadProgressConsumer.accept(current, total);
        }
    }

    protected void readStreams(Process process, Thread mainThread) throws IOException, InterruptedException {
        try (InputStream inputStream = process.getInputStream();
             InputStream errStream = process.getErrorStream();){
            String remaining;
            byte[] buffer = new byte[1024];
            StringBuilder processBuff = new StringBuilder();
            StringBuilder errBuff = new StringBuilder();
            while (process.isAlive() || inputStream.available() > 0 || errStream.available() > 0) {
                String line;
                int newLineIndex;
                if (!mainThread.isAlive()) {
                    process.destroyForcibly();
                    return;
                }
                if (inputStream.available() > 0) {
                    processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                    while ((newLineIndex = processBuff.indexOf(System.lineSeparator())) != -1) {
                        line = processBuff.substring(0, newLineIndex);
                        this.output(line + System.lineSeparator());
                        processBuff.delete(0, newLineIndex + System.lineSeparator().length());
                    }
                }
                if (errStream.available() > 0) {
                    errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                    while ((newLineIndex = errBuff.indexOf(System.lineSeparator())) != -1) {
                        line = errBuff.substring(0, newLineIndex);
                        this.error(line + System.lineSeparator());
                        errBuff.delete(0, newLineIndex + System.lineSeparator().length());
                    }
                }
                Thread.sleep(60L);
            }
            if (inputStream.available() > 0) {
                processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                remaining = processBuff.toString();
                if (!remaining.isEmpty()) {
                    this.output(remaining + System.lineSeparator());
                }
            }
            if (errStream.available() > 0) {
                errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                remaining = errBuff.toString();
                if (!remaining.isEmpty()) {
                    this.error(remaining + System.lineSeparator());
                }
            }
        }
    }
}

