/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.function.BiConsumer;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apposed.appose.Appose;
import org.apposed.appose.util.FileDownloader;
import org.apposed.appose.util.FilePaths;

public final class Downloads {
    private Downloads() {
    }

    public static File download(String name, String urlPath, BiConsumer<Long, Long> progressConsumer) throws IOException, InterruptedException, URISyntaxException {
        File tempFile = File.createTempFile(name + "-", FilePaths.fileType(urlPath));
        tempFile.deleteOnExit();
        URL url = Downloads.redirectedURL(new URL(urlPath));
        long size = Downloads.getFileSize(url);
        Thread currentThread = Thread.currentThread();
        IOException[] ioe = new IOException[]{null};
        InterruptedException[] ie = new InterruptedException[]{null};
        Thread dwnldThread = new Thread(() -> {
            try (ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                 FileOutputStream fos = new FileOutputStream(tempFile);){
                new FileDownloader(rbc, fos).call(currentThread);
            }
            catch (IOException e) {
                ioe[0] = e;
            }
            catch (InterruptedException e) {
                ie[0] = e;
            }
        });
        dwnldThread.start();
        while (dwnldThread.isAlive()) {
            Thread.sleep(20L);
            if (progressConsumer == null) continue;
            progressConsumer.accept(tempFile.length(), size);
        }
        if (ioe[0] != null) {
            throw ioe[0];
        }
        if (ie[0] != null) {
            throw ie[0];
        }
        if (tempFile.length() < size) {
            throw new IOException("Error downloading " + name + " from: " + urlPath);
        }
        return tempFile;
    }

    public static void unBZip2(File source, File destination) throws FileNotFoundException, IOException, InterruptedException {
        try (BZip2CompressorInputStream input = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(source)));
             FileOutputStream output = new FileOutputStream(destination);){
            Downloads.copy((InputStream)input, output);
        }
    }

    private static long copy(InputStream input, OutputStream output) throws IOException, InterruptedException {
        int bufferSize = 4096;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Decompressing stopped.");
            }
            if (output != null) {
                output.write(buffer, 0, n);
            }
            count += (long)n;
        }
        return count;
    }

    public static void unpack(File inputFile, File outputDir) throws FileNotFoundException, IOException, InterruptedException {
        String filename = inputFile.getName().toLowerCase();
        if (filename.endsWith(".tar")) {
            Downloads.unTar(inputFile, outputDir);
        } else if (filename.endsWith(".tar.bz2")) {
            Downloads.unBZip2(inputFile, outputDir);
        } else if (filename.endsWith(".tar.gz")) {
            Downloads.unTarGz(inputFile, outputDir);
        } else if (filename.endsWith(".zip")) {
            Downloads.unZip(inputFile, outputDir);
        } else {
            throw new IllegalArgumentException("Unsupported archive type for file: " + inputFile.getName());
        }
    }

    public static void unZip(File source, File destination) throws FileNotFoundException, IOException, InterruptedException {
        try (FileInputStream is = new FileInputStream(source);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ZipArchiveEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File outputFile = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IOException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + outputFile.getParentFile().getAbsolutePath());
                }
                try (FileOutputStream outputFileStream = new FileOutputStream(outputFile);){
                    Downloads.copy((InputStream)zipInputStream, outputFileStream);
                }
                if ((entry.getUnixMode() & 0x40) == 0) continue;
                outputFile.setExecutable(true);
            }
        }
    }

    public static void unTar(File inputFile, File outputDir) throws FileNotFoundException, IOException, InterruptedException {
        try (FileInputStream is = new FileInputStream(inputFile);
             TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);){
            TarArchiveEntry entry = null;
            while ((entry = debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IOException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + outputFile.getParentFile().getAbsolutePath());
                }
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                Throwable throwable = null;
                try {
                    Downloads.copy((InputStream)debInputStream, outputFileStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputFileStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputFileStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputFileStream).close();
                }
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    public static void unTarGz(File inputFile, File outputDir) throws FileNotFoundException, IOException, InterruptedException {
        try (FileInputStream is = new FileInputStream(inputFile);
             GzipCompressorInputStream gzipIs = new GzipCompressorInputStream((InputStream)new BufferedInputStream(is));
             TarArchiveInputStream tarInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)gzipIs);){
            TarArchiveEntry entry = null;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IOException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + outputFile.getParentFile().getAbsolutePath());
                }
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                Throwable throwable = null;
                try {
                    Downloads.copy((InputStream)tarInputStream, outputFileStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputFileStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputFileStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputFileStream).close();
                }
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    public static URL redirectedURL(URL url) throws MalformedURLException, URISyntaxException {
        int statusCode;
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)url.openConnection();
            statusCode = conn.getResponseCode();
        }
        catch (IOException ex) {
            return url;
        }
        if (statusCode < 300 || statusCode > 308) {
            return url;
        }
        String newURL = conn.getHeaderField("Location");
        try {
            return Downloads.redirectedURL(new URL(newURL));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                if (newURL.startsWith("//")) {
                    return Downloads.redirectedURL(new URL("http:" + newURL));
                }
                throw new MalformedURLException();
            }
            catch (MalformedURLException malformedURLException2) {
                URI uri = url.toURI();
                String scheme = uri.getScheme();
                String host = uri.getHost();
                String mainDomain = scheme + "://" + host;
                return Downloads.redirectedURL(new URL(mainDomain + newURL));
            }
        }
    }

    public static long getFileSize(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", Downloads.userAgent());
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() <= 308) {
                return Downloads.getFileSize(Downloads.redirectedURL(url));
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("Unable to connect to: " + url.toString());
            }
            long size = conn.getContentLengthLong();
            conn.disconnect();
            return size;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Unable to connect to " + url.toString();
            System.out.println(msg);
            return 1L;
        }
    }

    private static String userAgent() {
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String os = osName + "-" + (osVersion != null ? osVersion + "-" : "") + osArch;
        return "Appose/" + Appose.version() + " (Java " + javaVersion + "/" + os + ")";
    }
}

