/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.imagej.launcher.ClassLauncher;
import net.imagej.launcher.ClassLoaderPlus;

public class JarLauncher {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Missing argument");
            System.exit(1);
        }
        String[] shifted = new String[args.length - 1];
        System.arraycopy(args, 1, shifted, 0, shifted.length);
        JarLauncher.launchJar(args[0], shifted);
    }

    public static void launchJar(String jarPath, String[] arguments) {
        String className;
        JarFile jar = null;
        try {
            jar = new JarFile(jarPath);
        }
        catch (IOException e) {
            System.err.println("Could not read '" + jarPath + "'.");
            System.exit(1);
            return;
        }
        Manifest manifest = null;
        try {
            manifest = jar.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (manifest == null) {
            System.err.println("No manifest found in '" + jarPath + "'.");
            System.exit(1);
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String string = className = attributes == null ? null : attributes.getValue("Main-Class");
        if (className == null) {
            System.err.println("No main class attribute found in '" + jarPath + "'.");
            System.exit(1);
        }
        URLClassLoader loader = ClassLoaderPlus.get(null, new File(jarPath));
        ClassLauncher.launch(loader, className, arguments);
    }
}

