/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.ui.keymap;

import bdv.viewer.NavigationActions;
import java.util.stream.IntStream;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.util.Actions;

public class UnmappedNavigationActions
extends NavigationActions {
    public UnmappedNavigationActions(KeyStrokeAdder.Factory keyConfig) {
        super(keyConfig);
    }

    public static void install(Actions actions, boolean is2D) {
        UnmappedNavigationActions.installModeActions(actions);
        UnmappedNavigationActions.installSourceActions(actions);
        UnmappedNavigationActions.installTimeActions(actions);
        UnmappedNavigationActions.installAlignPlaneActions(actions, is2D);
    }

    public static void installModeActions(Actions actions) {
        actions.runnableAction(() -> {}, "toggle interpolation", new String[]{"not mapped"});
        actions.runnableAction(() -> {}, "toggle fused mode", new String[]{"not mapped"});
        actions.runnableAction(() -> {}, "toggle grouping", new String[]{"not mapped"});
    }

    public static void installTimeActions(Actions actions) {
        actions.runnableAction(() -> {}, "next timepoint", new String[]{"not mapped"});
        actions.runnableAction(() -> {}, "previous timepoint", new String[]{"not mapped"});
    }

    public static void installSourceActions(Actions actions) {
        String[] numkeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        IntStream.range(0, numkeys.length).forEach(i -> {
            actions.runnableAction(() -> {}, String.format("set current source %d", i), new String[]{String.format("%s", numkeys[i])});
            actions.runnableAction(() -> {}, String.format("toggle source visibility %d", i), new String[]{String.format("shift %s", numkeys[i])});
        });
    }

    public static void installAlignPlaneActions(Actions actions, boolean is2D) {
        actions.runnableAction(() -> {}, "align XY plane", new String[]{"not mapped"});
        if (!is2D) {
            actions.runnableAction(() -> {}, "align ZY plane", new String[]{"not mapped"});
            actions.runnableAction(() -> {}, "align XZ plane", new String[]{"not mapped"});
        }
    }
}

