/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.gui.Image5DCanvas;
import sc.fiji.i5d.gui.Image5DWindow;

public class OpenImage5DAdapter {
    public static ImageWindow makeOpenWindow(ImageWindow iw) {
        Object iwOut = iw;
        if (iw instanceof StackWindow && !(iw instanceof Image5DWindow) && !(iw instanceof OpenStackWindow)) {
            ImageCanvas ic = iw.getCanvas();
            ImagePlus img = iw.getImagePlus();
            img.setOpenAsHyperStack(true);
            double magn = ic.getMagnification();
            iwOut = new OpenStackWindow(img, ic);
            ic.setMagnification(magn);
            img.repaintWindow();
        } else if (iw instanceof Image5DWindow && !(iw instanceof OpenImage5DWindow)) {
            ImageCanvas ic = iw.getCanvas();
            ImagePlus img = iw.getImagePlus();
            double magn = ic.getMagnification();
            iwOut = new OpenImage5DWindow((Image5D)img, (Image5DCanvas)ic);
            ic.setMagnification(magn);
            img.repaintWindow();
        }
        return iwOut;
    }

    public static boolean isOpenWindow(ImageWindow iw) {
        return iw instanceof OpenStackWindow | iw instanceof OpenImage5DWindow;
    }

    public static boolean isImage5DWindow(ImageWindow iw) {
        return iw instanceof OpenImage5DWindow;
    }

    public static void addDisplayChangeListener(ImageWindow iw, DisplayChangeListener dcl) {
        if (iw instanceof OpenStackWindow) {
            ((OpenStackWindow)iw).addDisplayChangeListener(dcl);
        } else if (iw instanceof OpenImage5DWindow) {
            ((OpenImage5DWindow)iw).addDisplayChangeListener(dcl);
        }
    }

    public static void removeDisplayChangeListener(ImageWindow iw, DisplayChangeListener dcl) {
        if (iw instanceof OpenStackWindow) {
            ((OpenStackWindow)iw).removeDisplayChangeListener(dcl);
        } else if (iw instanceof OpenImage5DWindow) {
            ((OpenImage5DWindow)iw).removeDisplayChangeListener(dcl);
        }
    }

    public static void setChannel(ImagePlus imp, int value) {
        if (imp instanceof Image5D) {
            Image5D i5d = (Image5D)imp;
            i5d.setCurrentPosition(2, value - 1);
        }
    }

    public static void setFrame(ImagePlus imp, int value) {
        if (imp instanceof Image5D) {
            Image5D i5d = (Image5D)imp;
            i5d.setCurrentPosition(4, value - 1);
        }
    }
}

