/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import java.io.IOException;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Cast;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.MenuBar;
import sc.fiji.labkit.ui.actions.AbstractFileIoAction;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.labeling.LabelingSerializer;
import sc.fiji.labkit.ui.models.LabelingModel;

public class LabelingIoAction
extends AbstractFileIoAction {
    private final LabelingModel labelingModel;
    private final LabelingSerializer serializer;

    public LabelingIoAction(Extensible extensible, final LabelingModel labelingModel) {
        super(extensible, AbstractFileIoAction.LABELING_FILTER, AbstractFileIoAction.TIFF_FILTER);
        this.labelingModel = labelingModel;
        this.serializer = new LabelingSerializer(extensible.context());
        this.initSaveAction(MenuBar.LABELING_MENU, "Save Labeling ...", 2.0f, new AbstractFileIoAction.Action<Void>(){

            @Override
            public String suggestedFile() {
                return LabelingIoAction.this.labelingModel.defaultFileName();
            }

            @Override
            public void run(Void ignore, String filename) throws Exception {
                LabelingIoAction.this.serializer.save(labelingModel.labeling().get(), filename);
            }
        }, "ctrl S");
        this.initOpenAction(MenuBar.LABELING_MENU, "Open Labeling ...", 1.0f, this::open, "ctrl O");
        extensible.addMenuItem(MenuBar.LABELING_MENU, "Show Labeling in ImageJ", 3.0f, ignore -> this.showLabelingInImageJ(), null, "");
    }

    private void showLabelingInImageJ() {
        RandomAccessibleInterval<? extends IntegerType<?>> img = this.labelingModel.labeling().get().getIndexImg();
        ImageJFunctions.show((RandomAccessibleInterval)((RandomAccessibleInterval)Cast.unchecked(img)), (String)"Labeling");
    }

    private void open(Void ignore, String filename) throws IOException {
        Labeling labeling = this.serializer.open(filename);
        this.labelingModel.labeling().set(labeling);
    }
}

