/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.labeling;

import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.DefaultHolder;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.utils.ARGBVector;
import sc.fiji.labkit.ui.utils.ConcurrentIntFunctionCache;
import sc.fiji.labkit.ui.utils.ParametricNotifier;

public class LabelsLayer
implements BdvLayer {
    private final LabelingModel model;
    private final Holder<BdvShowable> showable;
    private final ParametricNotifier<Interval> listeners = new ParametricNotifier();
    private final ARGBType BLACK = new ARGBType(0);

    public LabelsLayer(LabelingModel model) {
        this.model = model;
        this.showable = new DefaultHolder<BdvShowable>(BdvShowable.wrap(this.colorView(), model.labelTransformation()));
        model.labeling().notifier().addListener(this::updateView);
        model.dataChangedNotifier().addListener(interval -> this.listeners.notifyListeners((Interval)interval));
    }

    private void updateView() {
        this.showable.set(BdvShowable.wrap(this.colorView(), this.model.labelTransformation()));
        this.listeners.notifyListeners(null);
    }

    private RandomAccessibleInterval<ARGBType> colorView() {
        Labeling labeling = this.model.labeling().get();
        List<Set<Label>> labelSets = labeling.getLabelSets();
        IntFunction<ARGBType> getColor = i -> this.getColor((Set)labelSets.get(i));
        ConcurrentIntFunctionCache<ARGBType> cachedGetColor = new ConcurrentIntFunctionCache<ARGBType>(getColor);
        return Converters.convert(labeling.getIndexImg(), (in, out) -> out.set((ARGBType)cachedGetColor.apply(in.getInteger())), (Type)new ARGBType());
    }

    private ARGBType getColor(Set<Label> set) {
        List<Label> visible = set.stream().filter(Label::isVisible).collect(Collectors.toList());
        if (visible.isEmpty()) {
            return this.BLACK;
        }
        ARGBVector collector = new ARGBVector();
        visible.forEach(label -> collector.add(label.color()));
        collector.div(visible.size());
        return collector.get();
    }

    @Override
    public Holder<BdvShowable> image() {
        return this.showable;
    }

    @Override
    public ParametricNotifier<Interval> listeners() {
        return this.listeners;
    }

    @Override
    public Holder<Boolean> visibility() {
        return this.model.labelingVisibility();
    }

    @Override
    public String title() {
        return "Labeling";
    }
}

