/*
 * Decompiled with CFR 0.152.
 */
package preview.net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.ConstantUtils;
import preview.net.imglib2.algorithm.neighborhood.HyperEllipsoidNeighborhood;
import preview.net.imglib2.algorithm.neighborhood.HyperEllipsoidNeighborhoodUnsafe;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodIterableInterval;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodRandomAccessible;

public class HyperEllipsoidShape
implements Shape {
    private final double[] radius;

    public HyperEllipsoidShape(double[] radius) {
        this.radius = radius;
    }

    public <T> NeighborhoodIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        return new NeighborhoodIterableInterval<T>(source, HyperEllipsoidNeighborhoodUnsafe.factory(this.radius));
    }

    public <T> NeighborhoodRandomAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        return new NeighborhoodRandomAccessible<T>(source, HyperEllipsoidNeighborhoodUnsafe.factory(this.radius));
    }

    public <T> NeighborhoodIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodIterableInterval<T>(source, HyperEllipsoidNeighborhood.factory(this.radius));
    }

    public <T> NeighborhoodRandomAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        return new NeighborhoodRandomAccessible<T>(source, HyperEllipsoidNeighborhood.factory(this.radius));
    }

    public double[] getRadius() {
        return (double[])this.radius.clone();
    }

    public String toString() {
        return "HyperEllipsoidShape, radius = " + this.radius;
    }

    public Interval getStructuringElementBoundingBox(int numDimensions) {
        RandomAccess dummyRandomAccess = ConstantUtils.constantRandomAccessible((Object)null, (int)numDimensions).randomAccess();
        Neighborhood neighborhood = HyperEllipsoidNeighborhood.factory(this.radius).create(new long[numDimensions], dummyRandomAccess);
        return neighborhood.getStructuringElementBoundingBox();
    }
}

