/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.algorithms;

import java.util.ArrayList;
import java.util.List;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuConcatenatedNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuSeparableOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;

public class GpuNeighborhoodOperations {
    private GpuNeighborhoodOperations() {
    }

    public static GpuNeighborhoodOperation concat(GpuApi gpu, List<? extends GpuNeighborhoodOperation> convolutions) {
        return new GpuConcatenatedNeighborhoodOperation(gpu, convolutions);
    }

    public static GpuNeighborhoodOperation min(GpuApi gpu, int[] windowSize) {
        return GpuNeighborhoodOperations.separableOperation(gpu, GpuSeparableOperation.Operation.MIN, windowSize);
    }

    public static GpuNeighborhoodOperation max(GpuApi gpu, int[] windowSize) {
        return GpuNeighborhoodOperations.separableOperation(gpu, GpuSeparableOperation.Operation.MAX, windowSize);
    }

    public static GpuNeighborhoodOperation mean(GpuApi gpu, int[] windowSize) {
        return GpuNeighborhoodOperations.separableOperation(gpu, GpuSeparableOperation.Operation.MEAN, windowSize);
    }

    public static GpuNeighborhoodOperation min1d(GpuApi gpu, int windowSize, int d) {
        return new GpuSeparableOperation(gpu, GpuSeparableOperation.Operation.MIN, windowSize, d);
    }

    public static GpuNeighborhoodOperation max1d(GpuApi gpu, int windowSize, int d) {
        return new GpuSeparableOperation(gpu, GpuSeparableOperation.Operation.MAX, windowSize, d);
    }

    public static GpuNeighborhoodOperation mean1d(GpuApi gpu, int windowSize, int d) {
        return new GpuSeparableOperation(gpu, GpuSeparableOperation.Operation.MEAN, windowSize, d);
    }

    private static GpuNeighborhoodOperation separableOperation(GpuApi gpu, GpuSeparableOperation.Operation operation, int[] windowSize) {
        ArrayList<GpuSeparableOperation> steps = new ArrayList<GpuSeparableOperation>();
        for (int d = 0; d < windowSize.length; ++d) {
            steps.add(new GpuSeparableOperation(gpu, operation, windowSize[d], d));
        }
        return GpuNeighborhoodOperations.concat(gpu, steps);
    }
}

