/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.gauss;

import java.util.Collections;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.gpu.GpuFeatureInput;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuCopy;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;

@Plugin(type=FeatureOp.class, label="gaussian blur")
public class SingleGaussianBlurFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma = 1.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("gaussian blur sigma=" + this.sigma);
    }

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        LoopBuilder.setImages(input.gauss(this.sigma), output.get(0)).forEachPixel((i, o) -> o.setReal(i.getRealFloat()));
    }

    @Override
    public void prefetch(GpuFeatureInput input) {
        input.prefetchGauss(this.sigma, input.targetInterval());
    }

    @Override
    public void apply(GpuFeatureInput input, List<GpuView> output) {
        GpuCopy.copyFromTo(input.gpuApi(), input.gauss(this.sigma, input.targetInterval()), output.get(0));
    }
}

