/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.vector;

import Jama.Matrix;
import ij.measure.Calibration;
import ini.trakem2.vector.Editions;
import ini.trakem2.vector.Util;
import ini.trakem2.vector.VectorString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class VectorString3D
implements VectorString {
    private double[] x;
    private double[] y;
    private double[] z;
    private double[] vx;
    private double[] vy;
    private double[] vz;
    private double[] rvx;
    private double[] rvy;
    private double[] rvz;
    private int length = 0;
    private double delta = 0.0;
    private byte tags = 0;
    public static final byte CLOSED = 16;
    public static final byte REVERSED = 8;
    public static final byte MIRROR_X = 4;
    public static final byte MIRROR_Y = 2;
    public static final byte MIRROR_Z = 1;
    private Calibration cal = null;
    private double[][] dep;
    private ArrayList<ArrayList<Point3d>> source = null;
    private int n_sources = 1;

    public VectorString3D(double[] x, double[] y, double[] z, boolean closed) throws Exception {
        if (x.length != y.length || x.length != z.length) {
            throw new Exception("x,y,z must have the same length.");
        }
        this.length = x.length;
        this.x = x;
        this.y = y;
        this.z = z;
        if (closed) {
            this.tags = (byte)(this.tags ^ 0x10);
        }
    }

    public void addDependent(double[] a) throws Exception {
        if (a.length != this.length) {
            throw new Exception("Dependent array must be of the same size as thevalue returned by length()");
        }
        if (null == this.dep) {
            this.dep = new double[1][];
            this.dep[0] = a;
        } else {
            double[][] dep2 = new double[this.dep.length + 1][];
            for (int i = 0; i < this.dep.length; ++i) {
                dep2[i] = this.dep[i];
            }
            dep2[this.dep.length] = a;
            this.dep = dep2;
        }
    }

    public double[] getDependent(int i) {
        return this.dep[i];
    }

    public double getAverageDelta() {
        double d = 0.0;
        for (int i = this.length - 1; i > 0; --i) {
            d += Math.sqrt(Math.pow(this.x[i] - this.x[i - 1], 2.0) + Math.pow(this.y[i] - this.y[i - 1], 2.0) + Math.pow(this.z[i] - this.z[i - 1], 2.0));
        }
        return d / (double)this.length;
    }

    @Override
    public double getDelta() {
        return this.delta;
    }

    @Override
    public void resample(double delta) {
        this.resample(delta, false);
    }

    @Override
    public void resample(double delta, boolean with_source) {
        if (Math.abs(delta - this.delta) < 1.0E-7) {
            return;
        }
        this.delta = delta;
        this.resample(with_source);
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public double[] getPoints(int dim) {
        switch (dim) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return null;
    }

    @Override
    public double[] getVectors(int dim) {
        switch (dim) {
            case 0: {
                return this.vx;
            }
            case 1: {
                return this.vy;
            }
            case 2: {
                return this.vz;
            }
        }
        return null;
    }

    @Override
    public double getPoint(int dim, int i) {
        switch (dim) {
            case 0: {
                return this.x[i];
            }
            case 1: {
                return this.y[i];
            }
            case 2: {
                return this.z[i];
            }
        }
        return 0.0;
    }

    @Override
    public double getVector(int dim, int i) {
        switch (dim) {
            case 0: {
                return this.vx[i];
            }
            case 1: {
                return this.vy[i];
            }
            case 2: {
                return this.vy[i];
            }
        }
        return 0.0;
    }

    public double getRelativeVector(int dim, int i) {
        switch (dim) {
            case 0: {
                return this.rvx[i];
            }
            case 1: {
                return this.rvy[i];
            }
            case 2: {
                return this.rvy[i];
            }
        }
        return 0.0;
    }

    @Override
    public final boolean isClosed() {
        return 0 != (this.tags & 0x10);
    }

    public void debug() {
        System.out.println("#### " + this.getClass().getName() + " ####");
        for (int i = 0; i < this.x.length; ++i) {
            System.out.println(i + ": " + this.x[i] + "," + this.y[i] + ", " + this.z[i]);
        }
        System.out.println("#### END ####");
    }

    private final void recalculate(double[] w, int length, double sum_) {
        double sum = 0.0;
        for (int q = 0; q < length; ++q) {
            w[q] = w[q] / sum_;
            sum += w[q];
        }
        double error = 1.0 - sum;
        if (error < 0.0) {
            error = -error;
        }
        if (error < 0.005) {
            w[0] = w[0] + (1.0 - sum);
        } else if (sum > 1.0) {
            this.recalculate(w, length, sum);
        }
    }

    private void resample(boolean with_source) {
        int last_i;
        double dist_ahead;
        int next_ahead;
        double MAX_DISTANCE = 2.5 * this.delta;
        int MA = (int)(MAX_DISTANCE / this.getAverageDelta());
        int MAX_AHEAD = MA < 6 ? 6 : MA;
        ResamplingData r = new ResamplingData(this.length, this.dep);
        Vector vector = new Vector();
        if (with_source && null == this.source) {
            this.source = new ArrayList();
            for (int g = 0; g < this.length; ++g) {
                ArrayList<Point3d> ap = new ArrayList<Point3d>();
                ap.add(new Point3d(this.x[g], this.y[g], this.z[g]));
                this.source.add(ap);
            }
        }
        ArrayList new_source = with_source ? new ArrayList() : null;
        r.setP(0, this.x[0], this.y[0], this.z[0]);
        r.setDeps(0, this.dep, new int[]{0}, new double[]{1.0}, 1);
        if (with_source) {
            new_source.add(new ArrayList(this.source.get(0)));
        }
        int i = 1;
        int j = 1;
        int prev_i = i;
        double[] w = new double[MAX_AHEAD];
        double[] distances = new double[MAX_AHEAD];
        Vector[] ve = new Vector[MAX_AHEAD];
        for (next_ahead = 0; next_ahead < MAX_AHEAD; ++next_ahead) {
            ve[next_ahead] = new Vector();
        }
        int[] ahead = new int[MAX_AHEAD];
        try {
            while (prev_i <= i && prev_i <= i && (this.isClosed() || i != this.length - 1)) {
                int u;
                next_ahead = 0;
                for (int t = 0; t < MAX_AHEAD; ++t) {
                    int s = i + t;
                    if (s >= this.length) {
                        if (!this.isClosed()) break;
                        s -= this.length;
                    }
                    if (!((dist_ahead = r.distance(j - 1, this.x[s], this.y[s], this.z[s])) < MAX_DISTANCE)) continue;
                    ahead[next_ahead] = s;
                    distances[next_ahead] = dist_ahead;
                    ++next_ahead;
                }
                if (0 == next_ahead) {
                    vector.set(this.x[i] - r.x(j - 1), this.y[i] - r.y(j - 1), this.z[i] - r.z(j - 1));
                    double dist1 = vector.length();
                    vector.setLength(this.delta);
                    vector.put(j, r);
                    if (with_source) {
                        new_source.add(new ArrayList(this.source.get(i)));
                    }
                    if (null != this.dep) {
                        r.setDeps(j, this.dep, new int[]{i}, new double[]{1.0}, 1);
                    }
                    if (dist1 <= this.delta) {
                        for (u = i; u < this.length; ++u) {
                            double dist2 = Math.sqrt(Math.pow(this.x[u] - r.x(j - 1), 2.0) + Math.pow(this.y[u] - r.y(j - 1), 2.0) + Math.pow(this.z[u] - r.z(j - 1), 2.0));
                            if (!(dist2 > this.delta)) continue;
                            prev_i = i;
                            i = u;
                            break;
                        }
                    }
                } else {
                    w[0] = distances[0] / MAX_DISTANCE;
                    double largest = w[0];
                    for (u = 1; u < next_ahead; ++u) {
                        w[u] = 1.0 - distances[u] / MAX_DISTANCE;
                        if (!(w[u] > largest)) continue;
                        largest = w[u];
                    }
                    double sum = 0.0;
                    for (u = 0; u < next_ahead; ++u) {
                        w[u] = w[u] / largest;
                        sum += w[u];
                    }
                    if (sum < 1.0) {
                        w[0] = w[0] + (1.0 - sum);
                    } else {
                        this.recalculate(w, next_ahead, sum);
                    }
                    vector.set(0.0, 0.0, 0.0);
                    ArrayList ap = with_source ? new ArrayList() : null;
                    for (u = 0; u < next_ahead; ++u) {
                        int iu = i + u;
                        if (iu >= this.length) {
                            iu -= this.length;
                        }
                        ve[u].set(this.x[iu] - r.x(j - 1), this.y[iu] - r.y(j - 1), this.z[iu] - r.z(j - 1));
                        ve[u].setLength(w[u] * this.delta);
                        vector.add(ve[u], u == next_ahead - 1);
                        if (!with_source) continue;
                        ap.addAll(this.source.get(iu));
                    }
                    if (with_source) {
                        new_source.add(ap);
                    }
                    if (Math.abs(vector.length() - this.delta) > 1.0E-8) {
                        vector.setLength(this.delta);
                    }
                    vector.put(j, r);
                    if (null != this.dep) {
                        r.setDeps(j, this.dep, ahead, w, next_ahead);
                    }
                    int ii = i;
                    for (int k = 0; k < next_ahead; ++k) {
                        if (!(distances[k] > this.delta)) continue;
                        ii = ahead[k];
                        break;
                    }
                    prev_i = i;
                    if (i == ii) {
                        i = ahead[next_ahead - 1] + 1;
                        if (i >= this.length) {
                            i = this.isClosed() ? (i -= this.length) : this.length - 1;
                        }
                    } else {
                        i = ii;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Some data: x,y,z .length = " + this.x.length + "," + this.y.length + "," + this.z.length + "\nj=" + j + ", i=" + i + ", prev_i=" + prev_i);
        }
        dist_ahead = r.distance(j - 1, this.x[this.length - 1], this.y[this.length - 1], this.z[this.length - 1]);
        int n = last_i = this.isClosed() ? 0 : this.length - 1;
        if (dist_ahead > this.delta * 1.2) {
            while (dist_ahead > this.delta * 1.2) {
                vector.set(this.x[last_i] - r.x(j - 1), this.y[last_i] - r.y(j - 1), this.z[last_i] - r.z(j - 1));
                vector.setLength(this.delta);
                vector.put(j, r);
                if (with_source) {
                    new_source.add(new ArrayList(this.source.get(last_i)));
                }
                dist_ahead = r.distance(++j - 1, this.x[last_i], this.y[last_i], this.z[last_i]);
            }
        }
        r.put(this, j);
        if (with_source) {
            this.source = new_source;
        }
    }

    public ArrayList<ArrayList<Point3d>> getSource() {
        return this.source;
    }

    public int getNSources() {
        return this.n_sources;
    }

    @Override
    public void reorder(int new_zero) {
        int j;
        double[] tmp = new double[this.length];
        double[] src = this.x;
        int i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.x = tmp;
        tmp = src;
        src = this.y;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.y = tmp;
        tmp = src;
        src = this.z;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.z = tmp;
        tmp = src;
        src = this.vx;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.vx = tmp;
        tmp = src;
        src = this.vy;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.vy = tmp;
        tmp = src;
        src = this.vz;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.vz = tmp;
        tmp = src;
    }

    @Override
    public double getDiffVectorLength(int i, int j, VectorString vsb) {
        VectorString3D vs = (VectorString3D)vsb;
        if (null == this.rvx || null == this.rvy || null == this.rvz) {
            double dx = this.vx[i] - vs.vx[j];
            double dy = this.vy[i] - vs.vy[j];
            double dz = this.vz[i] - vs.vz[j];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        double dx = this.rvx[i] - vs.rvx[j];
        double dy = this.rvy[i] - vs.rvy[j];
        double dz = this.rvz[i] - vs.rvz[j];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Object clone() {
        try {
            VectorString3D vs = new VectorString3D(Util.copy(this.x, this.length), Util.copy(this.y, this.length), Util.copy(this.z, this.length), this.isClosed());
            vs.delta = this.delta;
            if (null != this.vx) {
                vs.vx = Util.copy(this.vx, this.length);
            }
            if (null != this.vy) {
                vs.vy = Util.copy(this.vy, this.length);
            }
            if (null != this.vz) {
                vs.vz = Util.copy(this.vz, this.length);
            }
            if (null != this.rvx) {
                vs.rvx = Util.copy(this.rvx, this.length);
            }
            if (null != this.rvy) {
                vs.rvy = Util.copy(this.rvy, this.length);
            }
            if (null != this.rvz) {
                vs.rvz = Util.copy(this.rvz, this.length);
            }
            if (null != this.source) {
                vs.source = new ArrayList();
                for (ArrayList<Point3d> ap : this.source) {
                    vs.source.add(new ArrayList<Point3d>(ap));
                }
            }
            vs.tags = this.tags;
            vs.cal = null == this.cal ? null : this.cal.copy();
            return vs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList<ArrayList<Point3d>> cloneSource(int first, int last) {
        if (null == this.source) {
            return null;
        }
        ArrayList<ArrayList<Point3d>> s = new ArrayList<ArrayList<Point3d>>();
        int i = 0;
        for (ArrayList<Point3d> ap : this.source) {
            if (i < first) continue;
            if (i > last) break;
            s.add(new ArrayList<Point3d>(ap));
            ++i;
        }
        return s;
    }

    public VectorString3D makeReversedCopy() {
        try {
            VectorString3D vs = new VectorString3D(Util.copy(this.x, this.length), Util.copy(this.y, this.length), Util.copy(this.z, this.length), this.isClosed());
            vs.source = this.cloneSource(0, this.length - 1);
            vs.reverse();
            if (this.delta != 0.0 && null != this.vx) {
                vs.delta = this.delta;
                vs.resample(false);
                if (null != this.rvx) {
                    vs.relative();
                }
            }
            return vs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void relative() {
        if (null == this.vx || null == this.vy || null == this.vz) {
            this.resample(this.getAverageDelta());
        }
        this.rvx = new double[this.length];
        this.rvy = new double[this.length];
        this.rvz = new double[this.length];
        if (this.isClosed()) {
            this.rvx[0] = this.vx[0] + this.delta - this.vx[this.length - 1];
            this.rvy[0] = this.vy[0] - this.vy[this.length - 1];
            this.rvz[0] = this.vz[0] - this.vz[this.length - 1];
        }
        Vector vL = new Vector();
        Vector vA = new Vector();
        Vector vQ = new Vector();
        Vector vQQ = new Vector();
        Vector vQ2 = new Vector();
        double[][] m1 = new double[3][3];
        double[][] m2 = new double[3][3];
        for (int i = 1; i < this.length; ++i) {
            vL.set(this.delta, 0.0, 0.0);
            vL.normalize();
            vA.set(this.vx[i - 1], this.vy[i - 1], this.vz[i - 1]);
            vA.normalize();
            vQ.setCrossProduct(vA, vL);
            vQQ.setCrossProduct(vQ, vL);
            vQ.put(m1, 0);
            vL.put(m1, 1);
            vQQ.put(m1, 2);
            Matrix mat1 = new Matrix(m1);
            vQ.put(m2, 0);
            vA.put(m2, 1);
            vQ2.setCrossProduct(vQ, vA);
            vQ2.put(m2, 2);
            Matrix mat2 = new Matrix(m2).transpose();
            Matrix R = mat1.times(mat2);
            Matrix vB = new Matrix(new double[]{this.vx[i] - this.vx[i - 1], this.vy[i] - this.vy[i - 1], this.vz[i] - this.vz[i - 1]}, 1);
            Matrix vB_rot = R.transpose().times(vB.transpose());
            double[][] arr = vB_rot.getArray();
            this.rvx[i] = arr[0][0];
            this.rvy[i] = arr[1][0];
            this.rvz[i] = arr[2][0];
        }
    }

    public void equalize(double target_delta) {
        if (this.length < 2) {
            return;
        }
        double scale = target_delta / this.getAverageDelta();
        int i = 0;
        while (i < this.length) {
            int n = i;
            this.x[n] = this.x[n] * scale;
            int n2 = i;
            this.y[n2] = this.y[n2] * scale;
            int n3 = i++;
            this.z[n3] = this.z[n3] * scale;
        }
    }

    public static VectorString3D createRandom(int length, double delta, boolean closed) throws Exception {
        System.out.println("Creating random with length " + length + " and delta " + delta);
        double[] x = new double[length];
        double[] y = new double[length];
        double[] z = new double[length];
        Random rand = new Random(69997L);
        Vector v = new Vector();
        for (int i = 0; i < length; ++i) {
            v.set(rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0);
            v.setLength(delta);
            v.put(i, x, y, z);
        }
        VectorString3D vs = new VectorString3D(x, y, z, closed);
        vs.delta = delta;
        vs.vx = new double[length];
        vs.vy = new double[length];
        vs.vz = new double[length];
        for (int i = 1; i < length; ++i) {
            vs.vx[i] = vs.x[i] - vs.x[i - 1];
            vs.vy[i] = vs.y[i] - vs.y[i - 1];
            vs.vz[i] = vs.z[i] - vs.z[i - 1];
        }
        if (closed) {
            vs.vx[0] = vs.x[0] - vs.x[length - 1];
            vs.vy[0] = vs.y[0] - vs.y[length - 1];
            vs.vz[0] = vs.z[0] - vs.z[length - 1];
        }
        return vs;
    }

    public void calibrate(Calibration cal) {
        if (null != this.cal) {
            System.out.println("WARNING calibrating VectorString3D more than one time!");
        }
        if (null == cal) {
            return;
        }
        this.cal = cal;
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        int i = 0;
        while (i < this.x.length) {
            int n = i;
            this.x[n] = this.x[n] * cal.pixelWidth;
            int n2 = i;
            this.y[n2] = this.y[n2] * cal.pixelHeight;
            int n3 = i++;
            this.z[n3] = this.z[n3] * (cal.pixelWidth * (double)sign);
        }
        this.vz = null;
        this.vy = null;
        this.vx = null;
        this.rvz = null;
        this.rvy = null;
        this.rvx = null;
        this.delta = 0.0;
    }

    public void setCalibration(Calibration cal) {
        this.cal = cal;
    }

    public boolean isCalibrated() {
        return null != this.cal;
    }

    public Calibration getCalibrationCopy() {
        return null == this.cal ? null : this.cal.copy();
    }

    @Override
    public void reverse() {
        this.tags = (byte)(this.tags ^ 8);
        Util.reverse(this.x);
        Util.reverse(this.y);
        Util.reverse(this.z);
        this.delta = 0.0;
        if (null != this.vx || null != this.vy || null != this.vz) {
            this.vz = null;
            this.vy = null;
            this.vx = null;
        }
        if (null != this.rvx || null != this.rvy || null != this.rvz) {
            this.rvz = null;
            this.rvy = null;
            this.rvx = null;
        }
        if (null != this.source) {
            Collections.reverse(this.source);
        }
    }

    public boolean isReversed() {
        return 0 != (this.tags & 8);
    }

    public static VectorString3D createInterpolated(Editions ed, double alpha) throws Exception {
        VectorString3D vs1 = (VectorString3D)ed.getVS1();
        VectorString3D vs2 = (VectorString3D)ed.getVS2();
        return vs1.createInterpolated(vs2, ed, alpha);
    }

    public VectorString3D createInterpolated(VectorString3D other, Editions ed, double alpha) throws Exception {
        System.out.println("THIS METHOD IS BROKEN IN SOME UNKNOWN HORRIBLE WAY.\nFor now, use VectorString3D.createInterpolatedPoints(...) method, which is known to work -- even if conceptually not fully accurate.");
        if (Math.abs(this.delta - other.delta) > 1.0E-8) {
            throw new Exception("deltas are not the same: this.delta=" + this.delta + "  other.delta=" + other.delta);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            return null;
        }
        double[] vx1 = this.vx;
        double[] vy1 = this.vy;
        double[] vz1 = this.vz;
        double[] vx2 = other.vx;
        double[] vy2 = other.vy;
        double[] vz2 = other.vz;
        boolean relative = false;
        if (null != this.rvx && null != other.rvx) {
            vx1 = this.rvx;
            vy1 = this.rvy;
            vz1 = this.rvz;
            vx2 = other.rvx;
            vy2 = other.rvy;
            vz2 = other.rvz;
            relative = true;
        }
        int[][] editions = ed.getEditions();
        int n_editions = ed.length();
        double[] px = new double[n_editions];
        double[] py = new double[n_editions];
        double[] pz = new double[n_editions];
        px[0] = this.x[0] * (1.0 - alpha) + other.x[0] * alpha;
        py[0] = this.y[0] * (1.0 - alpha) + other.y[0] * alpha;
        pz[0] = this.z[0] * (1.0 - alpha) + other.z[0] * alpha;
        int start = 0;
        int end = n_editions;
        if (2 == editions[0][0] || 1 == editions[0][0]) {
            start = 1;
        }
        int n = this.length();
        int m = other.length();
        int i = 0;
        int j = 0;
        int next = 0;
        double vs_x = 0.0;
        double vs_y = 0.0;
        double vs_z = 0.0;
        Vector v = new Vector();
        Vector v_newref = new Vector();
        Vector v_delta = new Vector(this.delta, 0.0, 0.0);
        Vector v_i1 = new Vector();
        double[] d = new double[3];
        boolean with_source = null != this.source && null != other.source;
        ArrayList the_source = with_source ? new ArrayList() : null;
        try {
            for (int e = start; e < end; ++e) {
                i = editions[e][1];
                j = editions[e][2];
                if (this.isClosed()) {
                    if (i == n) {
                        i = 0;
                    }
                    if (j == m) {
                        j = 0;
                    }
                } else {
                    if (i == n) {
                        --i;
                    }
                    if (j == m) {
                        --j;
                    }
                }
                if (with_source) {
                    ArrayList ap = new ArrayList();
                    ap.addAll(this.source.get(i));
                    ap.addAll(other.source.get(j));
                    the_source.add(ap);
                }
                switch (editions[e][0]) {
                    case 2: {
                        vs_x = vx2[j] * alpha;
                        vs_y = vy2[j] * alpha;
                        vs_z = vz2[j] * alpha;
                        break;
                    }
                    case 1: {
                        vs_x = vx1[i] * (1.0 - alpha);
                        vs_y = vy1[i] * (1.0 - alpha);
                        vs_z = vz1[i] * (1.0 - alpha);
                        break;
                    }
                    case 3: {
                        vs_x = vx1[i] * (1.0 - alpha) + vx2[j] * alpha;
                        vs_y = vy1[i] * (1.0 - alpha) + vy2[j] * alpha;
                        vs_y = vz1[i] * (1.0 - alpha) + vz2[j] * alpha;
                        break;
                    }
                    default: {
                        System.out.println("\nIgnoring unknown edition " + editions[e][0]);
                    }
                }
                if (relative && 0 != i) {
                    v_newref.set(vx1[i], vy1[i], vz1[i]);
                    v_i1.set(vx1[i - 1], vy1[i - 1], vz1[i - 1]);
                    v.set(vs_x, vs_y, vs_z);
                    v.changeRef(v_delta, v_i1, v_newref);
                    v.put(d);
                    vs_x = vx1[i - 1] + d[0];
                    vs_y = vy1[i - 1] + d[1];
                    vs_z = vz1[i - 1] + d[2];
                }
                if (next + 1 == px.length) {
                    System.out.println("breaking early");
                    break;
                }
                px[next + 1] = px[next] + vs_x;
                py[next + 1] = py[next] + vs_y;
                py[next + 1] = py[next] + vs_z;
                ++next;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("next: " + next + " length: " + px.length + " i,j: " + i + ", " + j);
        }
        VectorString3D vs_interp = new VectorString3D(px, py, pz, this.isClosed());
        vs_interp.source = the_source;
        vs_interp.n_sources = this.n_sources + other.n_sources;
        return vs_interp;
    }

    public void mirror(int axis) {
        Transform3D t = new Transform3D();
        switch (axis) {
            case 0: {
                t.setScale(new Vector3d(-1.0, 1.0, 1.0));
                this.tags = (byte)(this.tags ^ 4);
                break;
            }
            case 1: {
                t.setScale(new Vector3d(1.0, -1.0, 1.0));
                this.tags = (byte)(this.tags ^ 2);
                break;
            }
            case 2: {
                t.setScale(new Vector3d(1.0, 1.0, -1.0));
                this.tags = (byte)(this.tags ^ 1);
                break;
            }
            default: {
                return;
            }
        }
        Point3d p = new Point3d();
        this.transform(this.x, this.y, this.z, t, p);
        if (null != this.vx) {
            this.transform(this.vx, this.vy, this.vz, t, p);
        }
        if (null != this.rvx) {
            this.transform(this.rvx, this.rvy, this.rvz, t, p);
        }
    }

    private final void transform(double[] x, double[] y, double[] z, Transform3D t, Point3d p) {
        for (int i = 0; i < this.length; ++i) {
            p.x = x[i];
            p.y = y[i];
            p.z = z[i];
            t.transform(p);
            x[i] = p.x;
            y[i] = p.y;
            z[i] = p.z;
        }
    }

    public boolean isMirroredX() {
        return 0 != (this.tags & 4);
    }

    public boolean isMirroredY() {
        return 0 != (this.tags & 2);
    }

    public boolean isMirroredZ() {
        return 0 != (this.tags & 1);
    }

    public byte getTags() {
        return this.tags;
    }

    public double computeLength() {
        double len = 0.0;
        for (int i = 1; i < this.length; ++i) {
            len += Math.sqrt(Math.pow(this.x[i] - this.x[i - 1], 2.0) + Math.pow(this.y[i] - this.y[i - 1], 2.0) + Math.pow(this.z[i] - this.z[i - 1], 2.0));
        }
        return len;
    }

    public Vector3d sumVector() {
        return new Vector3d(this.x[this.length - 1] - this.x[0], this.y[this.length - 1] - this.y[0], this.z[this.length - 1] - this.z[0]);
    }

    public static final double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static final double sqDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static final double distance(VectorString3D vs1, int i, VectorString3D vs2, int j) {
        return VectorString3D.distance(vs1.x[i], vs1.y[i], vs1.z[i], vs2.x[j], vs2.y[j], vs2.z[j]);
    }

    @Override
    public double distance(int i, VectorString vs, int j) {
        VectorString3D vs2 = (VectorString3D)vs;
        return VectorString3D.distance(this.x[i], this.y[i], this.z[i], vs2.x[j], vs2.y[j], vs2.z[j]);
    }

    public final double distance(int i, Point3d p) {
        return VectorString3D.distance(p.x, p.y, p.z, this.x[i], this.y[i], this.z[i]);
    }

    public void translate(Vector3d v) {
        int i = 0;
        while (i < this.length) {
            int n = i;
            this.x[n] = this.x[n] + v.x;
            int n2 = i;
            this.y[n2] = this.y[n2] + v.y;
            int n3 = i++;
            this.z[n3] = this.z[n3] + v.z;
        }
    }

    public void transform(Transform3D t) {
        Point3d p = new Point3d();
        if (null != this.x) {
            VectorString3D.transform(t, this.x, this.y, this.z, this.length, p);
        }
        if (null != this.vx) {
            VectorString3D.transform(t, this.vx, this.vy, this.vz, this.length, p);
        }
        if (null != this.rvx) {
            VectorString3D.transform(t, this.rvx, this.rvy, this.rvz, this.length, p);
        }
    }

    private static void transform(Transform3D t, double[] x, double[] y, double[] z, int length, Point3d p) {
        for (int i = 0; i < length; ++i) {
            p.x = x[i];
            p.y = y[i];
            p.z = z[i];
            t.transform(p);
            x[i] = p.x;
            y[i] = p.y;
            z[i] = p.z;
        }
    }

    public Point3d computeCenterOfMass() {
        Point3d v = new Point3d();
        for (int i = 0; i < this.length; ++i) {
            v.x += this.x[i] / (double)this.length;
            v.y += this.y[i] / (double)this.length;
            v.z += this.z[i] / (double)this.length;
        }
        return v;
    }

    @Override
    public VectorString subVectorString(int first, int last) throws Exception {
        boolean reverse;
        boolean bl = reverse = last < first;
        if (reverse) {
            int tmp = first;
            first = last;
            last = tmp;
        }
        int len = last - first + 1;
        double[] x = new double[len];
        double[] y = new double[len];
        double[] z = new double[len];
        System.arraycopy(this.x, first, x, 0, len);
        System.arraycopy(this.y, first, y, 0, len);
        System.arraycopy(this.z, first, z, 0, len);
        VectorString3D vs = new VectorString3D(x, y, z, this.isClosed());
        vs.source = this.cloneSource(first, last);
        if (reverse) {
            vs.reverse();
        }
        vs.cal = null == this.cal ? null : this.cal.copy();
        vs.tags = this.tags;
        vs.delta = this.delta;
        if (null != this.vx) {
            vs.delta = this.delta;
            vs.vx = new double[len];
            vs.vy = new double[len];
            vs.vz = new double[len];
            for (int i = 1; i < len; ++i) {
                vs.vx[i] = vs.x[i] - vs.x[i - 1];
                vs.vy[i] = vs.y[i] - vs.y[i - 1];
                vs.vz[i] = vs.z[i] - vs.z[i - 1];
            }
            if (null != this.rvx) {
                vs.relative();
            }
        }
        return vs;
    }

    public static VectorString3D createInterpolatedPoints(Editions ed, double alpha) {
        return VectorString3D.createInterpolatedPoints(ed, alpha, 0, ed.editions.length - 1);
    }

    public static VectorString3D createInterpolatedPoints(Editions ed, double alpha, int first, int last) {
        try {
            VectorString3D vs1 = (VectorString3D)ed.vs1;
            if (alpha <= 0.0) {
                return (VectorString3D)vs1.clone();
            }
            VectorString3D vs2 = (VectorString3D)ed.vs2;
            if (alpha >= 1.0) {
                return (VectorString3D)vs2.clone();
            }
            double[] x = new double[last - first + 1];
            double[] y = new double[x.length];
            double[] z = new double[x.length];
            int len1 = vs1.length();
            int len2 = vs2.length();
            boolean with_source = null != vs1.source && null != vs2.source;
            ArrayList the_source = with_source ? new ArrayList() : null;
            int k = first;
            int next = 0;
            while (k <= last) {
                int j;
                int[] e = ed.editions[k];
                int i = e[1];
                if (i >= len1) {
                    i = len1 - 1;
                }
                if ((j = e[2]) >= len2) {
                    j = len2 - 1;
                }
                x[next] = vs1.x[i] * alpha + vs2.x[j] * (1.0 - alpha);
                y[next] = vs1.y[i] * alpha + vs2.y[j] * (1.0 - alpha);
                z[next] = vs1.z[i] * alpha + vs2.z[j] * (1.0 - alpha);
                if (with_source) {
                    ArrayList ap = new ArrayList();
                    ap.addAll(vs1.source.get(i));
                    ap.addAll(vs2.source.get(j));
                    the_source.add(ap);
                }
                ++k;
                ++next;
            }
            if (with_source) {
                System.out.println("createInterpolatedPoints: lengths " + ed.editions.length + ", " + the_source.size() + " first,last: " + first + ", " + last);
            }
            VectorString3D vs = new VectorString3D(x, y, z, ed.vs1.isClosed());
            vs.source = the_source;
            vs.n_sources = vs1.n_sources + vs2.n_sources;
            vs.cal = null == vs1.cal ? null : vs1.cal.copy();
            vs.resample(vs1.delta, with_source);
            return vs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public VectorString3D chain(VectorString3D vs) {
        double d4;
        double d3;
        double d2;
        double min;
        if (this.isClosed() || vs.isClosed()) {
            System.out.println("Can't chain closed VectorString3D instances.");
            return null;
        }
        double d1 = VectorString3D.distance(this.x[0], this.y[0], this.z[0], vs.x[0], vs.y[0], vs.z[0]);
        if (d1 == (min = Math.min(d1, Math.min(d2 = VectorString3D.distance(this.x[this.length - 1], this.y[this.length - 1], this.z[this.length - 1], vs.x[0], vs.y[0], vs.z[0]), Math.min(d3 = VectorString3D.distance(this.x[0], this.y[0], this.z[0], vs.x[vs.length - 1], vs.y[vs.length - 1], vs.z[vs.length - 1]), d4 = VectorString3D.distance(this.x[this.length - 1], this.y[this.length - 1], this.z[this.length - 1], vs.x[vs.length - 1], vs.y[vs.length - 1], vs.z[vs.length - 1])))))) {
            VectorString3D vsr = (VectorString3D)vs.clone();
            vsr.reverse();
            return VectorString3D.concat(vsr, this);
        }
        if (d2 == min) {
            return VectorString3D.concat(this, vs);
        }
        if (d3 == min) {
            return VectorString3D.concat(vs, this);
        }
        VectorString3D vsr = (VectorString3D)vs.clone();
        vsr.reverse();
        return VectorString3D.concat(this, vsr);
    }

    private static final VectorString3D concat(VectorString3D vs1, VectorString3D vs2) {
        int len = vs1.length + vs2.length;
        double[] x = Util.copy(vs1.x, len);
        double[] y = Util.copy(vs1.y, len);
        double[] z = Util.copy(vs1.z, len);
        System.arraycopy(vs2.x, 0, x, vs1.length, vs2.length);
        System.arraycopy(vs2.y, 0, y, vs1.length, vs2.length);
        System.arraycopy(vs2.z, 0, z, vs1.length, vs2.length);
        try {
            return new VectorString3D(x, y, z, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public VectorString3D substring(int first, int last) {
        if (first < 0 || last > this.length) {
            return null;
        }
        int len = last - first;
        try {
            VectorString3D vs = new VectorString3D(Util.copy(this.x, first, len), Util.copy(this.y, first, len), Util.copy(this.z, first, len), false);
            vs.delta = this.delta;
            if (null != this.vx) {
                vs.vx = Util.copy(this.vx, first, len);
            }
            if (null != this.vy) {
                vs.vy = Util.copy(this.vy, first, len);
            }
            if (null != this.vz) {
                vs.vz = Util.copy(this.vz, first, len);
            }
            if (null != this.rvx) {
                vs.rvx = Util.copy(this.rvx, first, len);
            }
            if (null != this.rvy) {
                vs.rvy = Util.copy(this.rvy, first, len);
            }
            if (null != this.rvz) {
                vs.rvz = Util.copy(this.rvz, first, len);
            }
            if (null != this.source) {
                vs.source = new ArrayList();
                for (ArrayList<Point3d> ap : this.source) {
                    vs.source.add(new ArrayList<Point3d>(ap));
                }
            }
            vs.tags = this.tags;
            vs.cal = null == this.cal ? null : this.cal.copy();
            return vs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    public static final double getAverageVectorLength(int[] i, VectorString3D[] vs) {
        double len = 0.0;
        for (int k = vs.length; k > -1; --k) {
            VectorString3D v = vs[k];
            int j = i[k];
            len += Math.sqrt(Math.pow(v.x[j], 2.0) + Math.pow(v.y[j], 2.0) + Math.pow(v.z[j], 2.0));
        }
        return len / (double)vs.length;
    }

    public boolean isNear(VectorString3D vs, double radius) {
        double sq_radius = radius * radius;
        for (int k = 0; k < this.length; ++k) {
            for (int i = 0; i < vs.length; ++i) {
                double sqd = VectorString3D.sqDistance(this.x[k], this.y[k], this.z[k], vs.x[i], vs.y[i], vs.z[i]);
                if (!(sqd <= sq_radius)) continue;
                System.out.println("Found nearby " + vs + " at " + Math.sqrt(sqd));
                return true;
            }
        }
        return false;
    }

    public double[] getStdDevAtEachPoint() {
        if (null == this.source) {
            return null;
        }
        double[] stdDev = new double[this.length];
        int i = 0;
        System.out.println("len x: " + this.length + "  len source: " + this.source.size());
        for (ArrayList<Point3d> ap : this.source) {
            Point3d expected = new Point3d(this.x[i], this.y[i], this.z[i]);
            double sd = 0.0;
            for (Point3d p : ap) {
                sd += Math.pow(p.distance(expected), 2.0);
            }
            stdDev[i] = Math.sqrt(sd / (double)ap.size());
            ++i;
        }
        return stdDev;
    }

    static /* synthetic */ double[] access$002(VectorString3D x0, double[] x1) {
        x0.x = x1;
        return x1;
    }

    static /* synthetic */ double[] access$102(VectorString3D x0, double[] x1) {
        x0.y = x1;
        return x1;
    }

    static /* synthetic */ double[] access$202(VectorString3D x0, double[] x1) {
        x0.z = x1;
        return x1;
    }

    static /* synthetic */ double[] access$302(VectorString3D x0, double[] x1) {
        x0.vx = x1;
        return x1;
    }

    static /* synthetic */ double[] access$402(VectorString3D x0, double[] x1) {
        x0.vy = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(VectorString3D x0, double[] x1) {
        x0.vz = x1;
        return x1;
    }

    static /* synthetic */ double[][] access$702(VectorString3D x0, double[][] x1) {
        x0.dep = x1;
        return x1;
    }

    static class Vector {
        private double x;
        private double y;
        private double z;
        private double length;

        Vector() {
        }

        Vector(double x, double y, double z) {
            this.set(x, y, z);
        }

        Vector(Vector v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
            this.length = v.length;
        }

        public final Object clone() {
            return new Vector(this);
        }

        final void set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.length = this.computeLength();
        }

        final void normalize() {
            if (0.0 == this.length) {
                return;
            }
            if (Math.abs(1.0 - this.length) < 1.0E-8) {
                return;
            }
            this.x /= this.length;
            this.y /= this.length;
            this.z /= this.length;
            this.length = this.computeLength();
        }

        final double computeLength() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        final double length() {
            return this.length;
        }

        final void scale(double factor) {
            this.x *= factor;
            this.y *= factor;
            this.z *= factor;
            this.length = this.computeLength();
        }

        final void add(Vector v, boolean compute_length) {
            this.x += v.x;
            this.y += v.y;
            this.z += v.z;
            if (compute_length) {
                this.length = this.computeLength();
            }
        }

        final void setLength(double len) {
            this.normalize();
            this.scale(len);
        }

        final void put(int i, ResamplingData r) {
            r.setPV(i, r.x(i - 1) + this.x, r.y(i - 1) + this.y, r.z(i - 1) + this.z, this.x, this.y, this.z);
        }

        final void put(double[] d) {
            d[0] = this.x;
            d[1] = this.y;
            d[2] = this.z;
        }

        final void put(double[][] d, int col) {
            d[0][col] = this.x;
            d[1][col] = this.y;
            d[2][col] = this.z;
        }

        final void put(int i, double[] x, double[] y, double[] z) {
            x[i] = this.x;
            y[i] = this.y;
            z[i] = this.z;
        }

        final Vector getCrossProduct(Vector v) {
            return new Vector(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        }

        final void setCrossProduct(Vector v, Vector w) {
            this.x = v.y * w.z - v.z * w.y;
            this.y = v.z * w.x - v.x * w.z;
            this.z = v.x * w.y - v.y * w.x;
        }

        final void changeRef(Vector v_delta, Vector v_i1, Vector v_new1) {
            Vector a2 = new Vector(v_new1);
            a2.normalize();
            Vector a1 = a2.getCrossProduct(v_i1);
            a1.normalize();
            Vector a3 = a2.getCrossProduct(a1);
            double[][] m1 = new double[3][3];
            a1.put(m1, 0);
            a2.put(m1, 1);
            a3.put(m1, 2);
            Matrix mat1 = new Matrix(m1);
            Vector b2 = new Vector(v_delta);
            b2.normalize();
            Vector b3 = a1.getCrossProduct(b2);
            double[][] m2 = new double[3][3];
            a1.put(m2, 0);
            b2.put(m2, 1);
            b3.put(m2, 2);
            Matrix mat2 = new Matrix(m2).transpose();
            Matrix R = mat1.times(mat2);
            Matrix mthis = new Matrix(new double[]{this.x, this.y, this.z}, 1);
            Matrix v_rot = R.transpose().times(mthis.transpose());
            double[][] arr = v_rot.getArray();
            this.x = arr[0][0];
            this.y = arr[1][0];
            this.z = arr[2][0];
        }

        final Point3d asPoint3d() {
            return new Point3d(this.x, this.y, this.z);
        }
    }

    private class ResamplingData {
        private double[] rx;
        private double[] ry;
        private double[] rz;
        private double[] vx;
        private double[] vy;
        private double[] vz;
        private double[][] dep;

        ResamplingData(int length, double[][] dep) {
            this.rx = new double[length];
            this.ry = new double[length];
            this.rz = new double[length];
            this.vx = new double[length];
            this.vy = new double[length];
            this.vz = new double[length];
            if (null != dep) {
                this.dep = new double[dep.length][length];
            }
        }

        final void setP(int i, double xval, double yval, double zval) {
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            this.rx[i] = xval;
            this.ry[i] = yval;
            this.rz[i] = zval;
        }

        final void setPV(int i, double rxval, double ryval, double rzval, double xval, double yval, double zval) {
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            this.rx[i] = rxval;
            this.ry[i] = ryval;
            this.rz[i] = rzval;
            this.vx[i] = xval;
            this.vy[i] = yval;
            this.vz[i] = zval;
        }

        final void resize(int new_length) {
            this.rx = Util.copy(this.rx, new_length);
            this.ry = Util.copy(this.ry, new_length);
            this.rz = Util.copy(this.rz, new_length);
            this.vx = Util.copy(this.vx, new_length);
            this.vy = Util.copy(this.vy, new_length);
            this.vz = Util.copy(this.vz, new_length);
            if (null != this.dep) {
                double[][] dep2 = new double[this.dep.length][];
                for (int i = 0; i < this.dep.length; ++i) {
                    dep2[i] = Util.copy(this.dep[i], new_length);
                }
                this.dep = dep2;
            }
        }

        final double x(int i) {
            return this.rx[i];
        }

        final double y(int i) {
            return this.ry[i];
        }

        final double z(int i) {
            return this.rz[i];
        }

        final double distance(int i, double x, double y, double z) {
            return Math.sqrt(Math.pow(x - this.rx[i], 2.0) + Math.pow(y - this.ry[i], 2.0) + Math.pow(z - this.rz[i], 2.0));
        }

        final void put(VectorString3D vs, int length) {
            VectorString3D.access$002(vs, Util.copy(this.rx, length));
            VectorString3D.access$102(vs, Util.copy(this.ry, length));
            VectorString3D.access$202(vs, Util.copy(this.rz, length));
            VectorString3D.access$302(vs, Util.copy(this.vx, length));
            VectorString3D.access$402(vs, Util.copy(this.vy, length));
            VectorString3D.access$502(vs, Util.copy(this.vz, length));
            vs.length = length;
            if (null != this.dep) {
                VectorString3D.access$702(vs, new double[this.dep.length][]);
                for (int i = 0; i < this.dep.length; ++i) {
                    ((VectorString3D)vs).dep[i] = Util.copy(this.dep[i], length);
                }
            }
        }

        final void setDeps(int i, double[][] src_dep, int[] ahead, double[] weight, int len) {
            if (null == this.dep) {
                return;
            }
            if (i >= this.rx.length) {
                this.resize(i + 10);
            }
            for (int k = 0; k < this.dep.length; ++k) {
                for (int j = 0; j < len; ++j) {
                    double[] dArray = this.dep[k];
                    int n = i;
                    dArray[n] = dArray[n] + src_dep[k][ahead[j]] * weight[j];
                }
            }
        }
    }
}

