/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class SnapshotPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private Display display;
    private Displayable d;
    public static final int SIDE = 50;
    public static final Color GREY = new Color(215, 215, 215);
    private BufferedImage img = null;

    public SnapshotPanel(Display display, Displayable d) {
        this.display = display;
        this.d = d;
        Dimension dim = new Dimension(50, 50);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
    }

    public void set(Displayable d) {
        this.d = d;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void fillBackground(Graphics g, double lw, double lh, int slw, int slh) {
        if (lw != lh) {
            g.setColor(Color.black);
            g.fillRect(0, 0, slw, slh);
            g.setColor(GREY);
            g.fillRect(slw, 0, 50 - slw, 50);
            g.fillRect(0, slh, slw, 50 - slh);
        } else {
            g.setColor(Color.black);
            g.fillRect(0, 0, 50, 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        SnapshotPanel snapshotPanel = this;
        synchronized (snapshotPanel) {
            if (null != this.img) {
                g.drawImage(this.img, 0, 0, null);
                this.img.flush();
                this.img = null;
                return;
            }
        }
        Layer la = this.display.getLayer();
        if (null == la) {
            Utils.log2("SnapshotPanel: null layer?");
            return;
        }
        final double lw = la.getLayerWidth();
        final double lh = la.getLayerHeight();
        final double scale = Math.min(50.0 / lw, 50.0 / lh);
        final int slw = (int)(lw * scale);
        final int slh = (int)(lh * scale);
        this.fillBackground(g, lw, lh, slw, slh);
        FSLoader.repainter.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!SnapshotPanel.this.display.isPartiallyWithinViewport(SnapshotPanel.this.d)) {
                        return;
                    }
                    BufferedImage img = new BufferedImage(50, 50, 1);
                    Graphics2D g2 = img.createGraphics();
                    SnapshotPanel.this.fillBackground(g2, lw, lh, slw, slh);
                    g2.scale(scale, scale);
                    try {
                        Layer la = SnapshotPanel.this.display.getLayer();
                        SnapshotPanel.this.d.paintSnapshot(g2, la, la.getParent().getColorCueLayerRange(la), SnapshotPanel.this.d.getLayerSet().get2DBounds(), scale);
                    }
                    catch (Exception e) {
                        SnapshotPanel.this.d.paintAsBox(g2);
                    }
                    1 var3_4 = this;
                    synchronized (var3_4) {
                        if (null != SnapshotPanel.this.img) {
                            SnapshotPanel.this.img.flush();
                        }
                        SnapshotPanel.this.img = img;
                    }
                    SnapshotPanel.this.repaint();
                }
                catch (Throwable t) {
                    IJError.print(t);
                }
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.display.setActive(this.d);
        if (me.isPopupTrigger() || IJ.isMacOSX() && me.isControlDown() || 2 == me.getButton()) {
            this.display.showPopup(this, me.getX(), me.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }
}

