/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import ini.trakem2.imaging.P;
import ini.trakem2.io.ImageSaver;
import ini.trakem2.persistence.ImageBytes;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class RagMipMaps {
    public static final byte GREY = 1;
    public static final byte GREY_ALPHA = 2;
    public static final byte RGB = 3;
    public static final byte RGBA = 4;
    public static final int HEADER_SIZE = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean save(String path, byte[][] b, int width, int height) {
        if (!ImageSaver.checkPath(path)) {
            return false;
        }
        RandomAccessFile ra = null;
        try {
            ra = new RandomAccessFile(new File(path), "rw");
            byte[] h = new byte[]{(byte)(width >> 24 & 0xFF), (byte)(width >> 16 & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(height >> 24 & 0xFF), (byte)(height >> 16 & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(height & 0xFF), (byte)b.length};
            ra.write(h);
            if (1 == b.length || 3 == b.length) {
                for (int i = 0; i < b.length; ++i) {
                    ra.write(b[i]);
                }
            } else {
                for (int i = 0; i < b.length - 1; ++i) {
                    ra.write(b[i]);
                }
                ByteArrayOutputStream ba = new ByteArrayOutputStream(b.length);
                DeflaterOutputStream def = new DeflaterOutputStream((OutputStream)ba, new Deflater(4, false), 1024);
                def.write(b[b.length - 1]);
                def.finish();
                def.flush();
                ra.write((byte[])ImageSaver.Bbuf.get(ba), 0, ba.size());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != ra) {
                try {
                    ra.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
        return false;
    }

    public static final ImageBytes load(String path) {
        return RagMipMaps.load(path, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImageBytes load(String path, int retry) {
        RandomAccessFile ra = null;
        try {
            File f = new File(path);
            ra = new RandomAccessFile(f, "r");
            byte[] h = new byte[9];
            RagMipMaps.read(ra, h);
            int width = (h[0] & 0xFF) << 24 | (h[1] & 0xFF) << 16 | (h[2] & 0xFF) << 8 | h[3] & 0xFF;
            int height = (h[4] & 0xFF) << 24 | (h[5] & 0xFF) << 16 | (h[6] & 0xFF) << 8 | h[7] & 0xFF;
            int nCh = h[8];
            int chLength = width * height;
            byte[][] ch = CachingThread.getOrCreateByteArray(nCh, chLength);
            int end = 0 == nCh % 2 ? nCh - 1 : nCh;
            for (int i = 0; i < end; ++i) {
                RagMipMaps.read(ra, ch[i]);
            }
            if (end < nCh) {
                int r;
                int len = (int)(f.length() - 9L - (long)(chLength * (nCh - 1)));
                byte[] a = new byte[len];
                RagMipMaps.read(ra, a);
                ByteArrayInputStream ba = new ByteArrayInputStream(a);
                InflaterInputStream inf = new InflaterInputStream(ba, new Inflater(false), 1024);
                for (int sum = 0; sum < ch[nCh - 1].length && -1 != (r = inf.read(ch[nCh - 1], sum, ch[nCh - 1].length - sum)); sum += r) {
                }
            }
            ImageBytes imageBytes = new ImageBytes(ch, width, height);
            return imageBytes;
        }
        catch (FileNotFoundException fnfe) {
            Utils.log2("File not found: " + path);
        }
        catch (Exception e) {
            if (retry < 2) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ImageBytes imageBytes = RagMipMaps.load(path, retry + 1);
                return imageBytes;
            }
            IJError.print(e);
        }
        finally {
            if (null != ra) {
                try {
                    ra.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BufferedImage read(String path) {
        try {
            ImageBytes ib = RagMipMaps.load(path);
            if (null == ib) {
                return null;
            }
            byte[][] ch = ib.c;
            switch (ch.length) {
                case 1: {
                    return ImageSaver.createGrayImage(ch[0], ib.width, ib.height);
                }
            }
            try {
                switch (ch.length) {
                    case 2: {
                        BufferedImage bufferedImage = ImageSaver.createARGBImagePre(P.blendPre(ch[0], ch[1]), ib.width, ib.height);
                        return bufferedImage;
                    }
                    case 3: {
                        BufferedImage bufferedImage = ImageSaver.createRGBImage(P.blend(ch[0], ch[1], ch[2]), ib.width, ib.height);
                        return bufferedImage;
                    }
                    case 4: {
                        BufferedImage bufferedImage = ImageSaver.createARGBImagePre(P.blendPre(ch[0], ch[1], ch[2], ch[3]), ib.width, ib.height);
                        return bufferedImage;
                    }
                }
                return null;
            }
            finally {
                CachingThread.storeForReuse(ch);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    private static final void read(RandomAccessFile ra, byte[] b) throws IOException {
        int r;
        for (int s = 0; s < b.length; s += r) {
            r = ra.read(b, s, b.length - s);
            if (-1 != r) continue;
            return;
        }
    }
}

