/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import ini.trakem2.ControlWindow;
import ini.trakem2.utils.IJError;
import java.util.HashMap;

public abstract class Worker
implements Runnable {
    private String thread_name;
    private String task_name;
    private Thread thread;
    private volatile boolean working = false;
    protected volatile boolean quit = false;
    private volatile boolean started = false;
    private volatile boolean background = false;
    private boolean interrupt_on_quit = false;
    protected Object result = null;
    private boolean cleaned_up = false;
    private HashMap<Object, Object> properties = null;

    public Worker(String task_name) {
        this(task_name, !ControlWindow.isGUIEnabled() || null == IJ.getInstance());
    }

    public Worker(String task_name, boolean headless_mode) {
        this.thread_name = (headless_mode ? "Run$_" : "") + "Worker";
        this.task_name = task_name;
    }

    public Worker(String task_name, boolean headless_mode, boolean interrupt_on_quit) {
        this(task_name, headless_mode);
        this.interrupt_on_quit = interrupt_on_quit;
    }

    void setThread(Thread t) {
        this.thread = t;
    }

    public void setTaskName(String name) {
        this.task_name = name;
    }

    protected void startedWorking() {
        this.working = true;
        this.started = true;
    }

    public boolean hasStarted() {
        return this.started;
    }

    protected void finishedWorking() {
        this.working = false;
        this.quit = true;
    }

    public boolean isWorking() {
        return this.working;
    }

    public String getTaskName() {
        return this.task_name;
    }

    public String getThreadName() {
        return this.thread_name;
    }

    public void setPriority(int priority) {
        if (null != this.thread) {
            this.thread.setPriority(priority);
        }
    }

    public void quit() {
        this.quit = true;
        if (this.interrupt_on_quit && null != this.thread) {
            this.thread.getThreadGroup().interrupt();
        }
    }

    public void join() throws InterruptedException {
        if (null != this.thread) {
            this.thread.join();
        }
    }

    public boolean hasQuitted() {
        return this.quit;
    }

    protected void setAsBackground(boolean b) {
        this.background = b;
    }

    public boolean onBackground() {
        return this.background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup2() {
        Worker worker = this;
        synchronized (worker) {
            if (this.cleaned_up) {
                return;
            }
            this.cleaned_up = true;
        }
        this.cleanup();
    }

    public void cleanup() {
    }

    public Object getResult() {
        return this.result;
    }

    public synchronized void setProperty(Object key, Object value) {
        if (null == key) {
            return;
        }
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public synchronized Object getProperty(Object key) {
        if (null == key || null == this.properties) {
            return null;
        }
        return this.properties.get(key);
    }

    public static abstract class Task
    extends Worker {
        public Task(String title) {
            super(title);
        }

        public Task(String title, boolean interrupt_on_quit) {
            this(title);
            ((Worker)this).interrupt_on_quit = interrupt_on_quit;
        }

        public abstract void exec();

        @Override
        public void run() {
            try {
                this.startedWorking();
                this.exec();
            }
            catch (Throwable t) {
                IJError.print(t);
            }
            finally {
                this.finishedWorking();
            }
        }
    }
}

