/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class AWTImageTools {
    private AWTImageTools() {
    }

    public static BufferedImage createImage(int width, int height) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration config = env.getDefaultScreenDevice().getDefaultConfiguration();
        return config.createCompatibleImage(width, height);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage result = AWTImageTools.createImage(image.getWidth(null), image.getHeight(null));
        Graphics g = result.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }
}

