/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.test;

import fiji.util.node.Leaf;
import mpicbg.models.Point;

public class VirtualPointNode<P extends Point>
implements Leaf<VirtualPointNode<P>> {
    private static final long serialVersionUID = 1L;
    final P p;
    final int numDimensions;

    public VirtualPointNode(P p) {
        this.p = p;
        this.numDimensions = p.getL().length;
    }

    public P getPoint() {
        return this.p;
    }

    public float distanceTo(VirtualPointNode<P> other) {
        return (float)Point.distance(this.p, other.getPoint());
    }

    public float get(int k) {
        return (float)this.p.getW()[k];
    }

    public int getNumDimensions() {
        return this.numDimensions;
    }

    public boolean isLeaf() {
        return true;
    }

    public VirtualPointNode<P>[] createArray(int n) {
        return new VirtualPointNode[n];
    }
}

