/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal1;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.spim.io.IOFunctions;

public class DetectionSegmentation {
    public static <T extends RealType<T>> ArrayList<DifferenceOfGaussianPeak<T>> extractBeadsLaPlaceImgLib(Image<T> img, float initialSigma, float minPeakValue, float minInitialPeakValue) {
        return DetectionSegmentation.extractBeadsLaPlaceImgLib(img, new OutOfBoundsStrategyMirrorFactory(), 0.5f, initialSigma, minPeakValue, minInitialPeakValue, 4, true, false, 1);
    }

    public static <T extends RealType<T>> ArrayList<DifferenceOfGaussianPeak<T>> extractBeadsLaPlaceImgLib(Image<T> img, OutOfBoundsStrategyFactory<T> oobsFactory, float imageSigma, float initialSigma, float minPeakValue, float minInitialPeakValue, int stepsPerOctave, boolean findMax, boolean findMin, int debugLevel) {
        float k = (float)DetectionSegmentation.computeK(stepsPerOctave);
        float sigma1 = initialSigma;
        float sigma2 = initialSigma * k;
        return DetectionSegmentation.extractBeadsLaPlaceImgLib(img, oobsFactory, imageSigma, sigma1, sigma2, minPeakValue, minInitialPeakValue, findMax, findMin, debugLevel);
    }

    public static <T extends RealType<T>> ArrayList<DifferenceOfGaussianPeak<T>> extractBeadsLaPlaceImgLib(Image<T> img, OutOfBoundsStrategyFactory<T> oobsFactory, float imageSigma, float sigma1, float sigma2, float minPeakValue, float minInitialPeakValue, boolean findMax, boolean findMin, int debugLevel) {
        float[] sigmaXY = new float[]{sigma1, sigma2};
        float[] sigmaDiffXY = DetectionSegmentation.computeSigmaDiff(sigmaXY, imageSigma);
        float k = sigmaXY[1] / sigmaXY[0];
        float K_MIN1_INV = DetectionSegmentation.computeKWeight(k);
        double[][] sigmaDiff = new double[2][3];
        sigmaDiff[0][0] = sigmaDiffXY[0];
        sigmaDiff[0][1] = sigmaDiffXY[0];
        sigmaDiff[1][0] = sigmaDiffXY[1];
        sigmaDiff[1][1] = sigmaDiffXY[1];
        if (img.getNumDimensions() == 3) {
            float sigma1Z = Math.max(imageSigma * 2.0f, sigma1 / img.getCalibration(2));
            float sigma2Z = sigma1Z * k;
            float[] sigmaZ = new float[]{sigma1Z, sigma2Z};
            float[] sigmaDiffZ = DetectionSegmentation.computeSigmaDiff(sigmaZ, imageSigma);
            sigmaDiff[0][2] = sigmaDiffZ[0];
            sigmaDiff[1][2] = sigmaDiffZ[1];
        }
        DifferenceOfGaussianReal1 dog = new DifferenceOfGaussianReal1(img, oobsFactory, sigmaDiff[0], sigmaDiff[1], (double)minInitialPeakValue, (double)K_MIN1_INV);
        dog.setKeepDoGImage(true);
        if (!dog.checkInput() || !dog.process()) {
            if (debugLevel <= 2) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Cannot compute difference of gaussian for " + dog.getErrorMessage());
            }
            return new ArrayList<DifferenceOfGaussianPeak<T>>();
        }
        ArrayList peakList = dog.getPeaks();
        for (int i = peakList.size() - 1; i >= 0; --i) {
            if (!findMin && ((DifferenceOfGaussianPeak)peakList.get(i)).isMin()) {
                peakList.remove(i);
            }
            if (findMax || !((DifferenceOfGaussianPeak)peakList.get(i)).isMax()) continue;
            peakList.remove(i);
        }
        SubpixelLocalization spl = new SubpixelLocalization(dog.getDoGImage(), (List)dog.getPeaks());
        spl.setAllowMaximaTolerance(true);
        spl.setMaxNumMoves(10);
        if (!(spl.checkInput() && spl.process() || debugLevel > 2)) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Warning! Failed to compute subpixel localization " + spl.getErrorMessage());
        }
        dog.getDoGImage().close();
        int peakTooLow = 0;
        int invalid = 0;
        int extrema = 0;
        for (int i = peakList.size() - 1; i >= 0; --i) {
            DifferenceOfGaussianPeak maximum = (DifferenceOfGaussianPeak)peakList.get(i);
            if (!maximum.isValid()) {
                ++invalid;
            }
            if (findMax && maximum.isMax()) {
                ++extrema;
                if (Math.abs(((RealType)maximum.getValue()).getRealDouble()) < (double)minPeakValue) {
                    peakList.remove(i);
                    ++peakTooLow;
                }
            }
            if (!findMin || !maximum.isMin()) continue;
            ++extrema;
            if (!(Math.abs(((RealType)maximum.getValue()).getRealDouble()) < (double)minPeakValue)) continue;
            peakList.remove(i);
            ++peakTooLow;
        }
        if (debugLevel <= 0) {
            IOFunctions.println("number of peaks: " + dog.getPeaks().size());
            IOFunctions.println("invalid: " + invalid);
            IOFunctions.println("extrema: " + extrema);
            IOFunctions.println("peak to low: " + peakTooLow);
        }
        return peakList;
    }

    public static double computeK(float stepsPerOctave) {
        return Math.pow(2.0, 1.0f / stepsPerOctave);
    }

    public static double computeK(int stepsPerOctave) {
        return Math.pow(2.0, 1.0f / (float)stepsPerOctave);
    }

    public static float computeKWeight(float k) {
        return 1.0f / (k - 1.0f);
    }

    public static float[] computeSigma(float k, float initialSigma) {
        float[] sigma;
        sigma = new float[]{initialSigma, sigma[0] * k};
        return sigma;
    }

    public static float getDiffSigma(float sigmaA, float sigmaB) {
        return (float)Math.sqrt(sigmaB * sigmaB - sigmaA * sigmaA);
    }

    public static float[] computeSigmaDiff(float[] sigma, float imageSigma) {
        float[] sigmaDiff = new float[]{DetectionSegmentation.getDiffSigma(imageSigma, sigma[0]), DetectionSegmentation.getDiffSigma(imageSigma, sigma[1])};
        return sigmaDiff;
    }
}

