/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection.descriptor;

import java.util.ArrayList;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.Model;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.detection.DetectionView;
import mpicbg.spim.registration.detection.descriptor.CorrespondenceExtraction;

public class SparseCorrespondenceExtraction<M extends Model<M>, T extends DetectionView<?, T>>
implements CorrespondenceExtraction<T> {
    int debugLevel;
    final ViewDataBeads viewA;
    final ViewDataBeads viewB;

    public SparseCorrespondenceExtraction(ViewDataBeads viewA, ViewDataBeads viewB, M model) {
        this.debugLevel = viewA.getViewStructure().getDebugLevel();
        this.viewA = viewA;
        this.viewB = viewB;
    }

    @Override
    public ArrayList<PointMatchGeneric<T>> extractCorrespondenceCandidates(ArrayList<T> nodeListA, ArrayList<T> nodeListB, double differenceThreshold, double ratioOfDistance, boolean useAssociatedBeads) {
        int minNumCorrespondences = Math.max(this.viewA.getTile().getModel().getMinNumMatches(), this.viewB.getTile().getModel().getMinNumMatches());
        if (nodeListA.size() < minNumCorrespondences * 3) {
            if (this.debugLevel <= 2) {
                IOFunctions.println("Not enough beads found in " + this.viewA + ": " + nodeListA.size());
            }
            return new ArrayList<PointMatchGeneric<T>>();
        }
        if (nodeListB.size() < minNumCorrespondences * 3) {
            if (this.debugLevel <= 2) {
                IOFunctions.println("Not enough beads found in " + this.viewB + ": " + nodeListB.size());
            }
            return new ArrayList<PointMatchGeneric<T>>();
        }
        ArrayList<PointMatchGeneric<T>> correspondences = new ArrayList<PointMatchGeneric<T>>();
        for (DetectionView sparseBead : nodeListA) {
            double minDistance = Double.MAX_VALUE;
            DetectionView nearestBead = null;
            LinkedPoint<DetectionView> transformedBead = new LinkedPoint<DetectionView>(sparseBead.getL(), sparseBead.getW(), sparseBead);
            transformedBead.apply((CoordinateTransform)this.viewA.getTile().getModel());
            for (DetectionView nonSparseBead : nodeListB) {
                double distance = nonSparseBead.getDistance(transformedBead);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                nearestBead = nonSparseBead;
            }
            if (!(minDistance < 30.0)) continue;
            correspondences.add(new PointMatchGeneric<Object>(sparseBead, nearestBead, 1.0));
            sparseBead.addPointDescriptorCorrespondence(nearestBead, 1.0);
            nearestBead.addPointDescriptorCorrespondence(sparseBead, 1.0);
        }
        return correspondences;
    }
}

