/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import loci.formats.IFormatReader;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import spim.fiji.datasetmanager.LightSheetZ1MetaData;
import spim.fiji.datasetmanager.MultiViewDatasetDefinition;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.LegacyLightSheetZ1ImgLoader;
import spim.fiji.spimdata.imgloaders.LightSheetZ1ImgLoader;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class LightSheetZ1
implements MultiViewDatasetDefinition {
    public static String[] rotAxes = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    public static String defaultFirstFile = "";
    public static boolean defaultModifyCal = false;
    public static boolean defaultRotAxis = false;
    public static boolean defaultApplyRotAxis = true;
    public static boolean defaultFixBioformats = false;
    private boolean fixBioformats = false;

    @Override
    public String getTitle() {
        return "Zeiss Lightsheet Z.1 Dataset (LOCI Bioformats)";
    }

    @Override
    public String getExtendedDescription() {
        return "This datset definition supports files saved by the Zeiss Lightsheet Z.1\nmicroscope. By default, one file per time-point is saved by Zen, which includes\nall angles, channels and illumination directions. We support this format and\nmost other combinations that can be saved.\n\nNote: if you want to process multiple CZI datasets that are actually one experi-\nment (e.g. two channels individually acquired), please re-save them in Zen as\nCZI files containing only one 3d stack per file and use the dataset definition\n'3d Image Stacks (LOCI Bioformats)'";
    }

    @Override
    public SpimData2 createDataset() {
        File cziFile = this.queryCZIFile();
        if (cziFile == null) {
            return null;
        }
        LightSheetZ1MetaData meta = new LightSheetZ1MetaData();
        if (!meta.loadMetaData(cziFile)) {
            IOFunctions.println("Failed to analyze file.");
            return null;
        }
        if (!this.showDialogs(meta)) {
            return null;
        }
        String directory = cziFile.getParent();
        ImgFactory<? extends NativeType<?>> imgFactory = this.selectImgFactory(meta);
        TimePoints timepoints = this.createTimePoints(meta);
        ArrayList<ViewSetup> setups = this.createViewSetups(meta);
        MissingViews missingViews = null;
        SequenceDescription sequenceDescription = new SequenceDescription(timepoints, setups, null, missingViews);
        LightSheetZ1ImgLoader imgLoader = new LightSheetZ1ImgLoader(cziFile, imgFactory, (AbstractSequenceDescription<?, ?, ?>)sequenceDescription);
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
        double minResolution = Math.min(Math.min(meta.calX(), meta.calY()), meta.calZ());
        IOFunctions.println("Minimal resolution in all dimensions is: " + minResolution);
        IOFunctions.println("(The smallest resolution in any dimension; the distance between two pixels in the output image will be that wide)");
        ViewRegistrations viewRegistrations = StackList.createViewRegistrations(sequenceDescription.getViewDescriptions(), minResolution);
        ViewInterestPoints viewInterestPoints = new ViewInterestPoints();
        viewInterestPoints.createViewInterestPoints(sequenceDescription.getViewDescriptions());
        SpimData2 spimData = new SpimData2(new File(directory), sequenceDescription, viewRegistrations, viewInterestPoints, new BoundingBoxes());
        if (meta.applyAxis()) {
            Apply_Transformation.applyAxis(spimData);
        }
        if (this.fixBioformats) {
            this.fixBioformats(spimData, cziFile, meta);
        }
        return spimData;
    }

    protected ArrayList<ViewSetup> createViewSetups(LightSheetZ1MetaData meta) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (int c = 0; c < meta.numChannels(); ++c) {
            channels.add(new Channel(c, meta.channels()[c]));
        }
        ArrayList<Illumination> illuminations = new ArrayList<Illumination>();
        for (int i = 0; i < meta.numIlluminations(); ++i) {
            illuminations.add(new Illumination(i, meta.illuminations()[i]));
        }
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (int a = 0; a < meta.numAngles(); ++a) {
            Angle angle = new Angle(a, meta.angles()[a]);
            try {
                double degrees = Double.parseDouble(meta.angles()[a]);
                double[] axis = null;
                if (meta.rotationAxis() == 0) {
                    axis = new double[]{1.0, 0.0, 0.0};
                } else if (meta.rotationAxis() == 1) {
                    axis = new double[]{0.0, 1.0, 0.0};
                } else if (meta.rotationAxis() == 2) {
                    axis = new double[]{0.0, 0.0, 1.0};
                }
                if (axis != null && !Double.isNaN(degrees) && !Double.isInfinite(degrees)) {
                    angle.setRotation(axis, degrees);
                }
            }
            catch (Exception degrees) {
                // empty catch block
            }
            angles.add(angle);
        }
        ArrayList<ViewSetup> viewSetups = new ArrayList<ViewSetup>();
        for (Channel c : channels) {
            for (Illumination i : illuminations) {
                for (Angle a : angles) {
                    FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(meta.calUnit(), new double[]{meta.calX(), meta.calY(), meta.calZ()});
                    FinalDimensions dim = new FinalDimensions(meta.imageSizes().get(a.getId()));
                    viewSetups.add(new ViewSetup(viewSetups.size(), null, (Dimensions)dim, (VoxelDimensions)voxelSize, c, a, i));
                }
            }
        }
        return viewSetups;
    }

    protected TimePoints createTimePoints(LightSheetZ1MetaData meta) {
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        for (int t = 0; t < meta.numTimepoints(); ++t) {
            timepoints.add(new TimePoint(t));
        }
        return new TimePoints(timepoints);
    }

    protected ImgFactory<? extends NativeType<?>> selectImgFactory(LightSheetZ1MetaData meta) {
        long maxNumPixels = 0L;
        for (int a = 0; a < meta.numAngles(); ++a) {
            int[] dim = meta.imageSizes().get(a);
            long n = 1L;
            for (int d = 0; d < dim.length; ++d) {
                n *= (long)dim[d];
                if (dim[d] > 0) continue;
                IOFunctions.println("Dimensions couldn't be read from metadata, using CellImg(256).");
                return new CellImgFactory(new int[]{256});
            }
            maxNumPixels = Math.max(n, maxNumPixels);
        }
        int smallerLog2 = (int)Math.ceil(Math.log(maxNumPixels) / Math.log(2.0));
        String s = "Maximum number of pixels in any view: n=" + maxNumPixels + " (2^" + (smallerLog2 - 1) + " < n < 2^" + smallerLog2 + " px), ";
        if (smallerLog2 <= 31) {
            IOFunctions.println(s + "using ArrayImg.");
            return new ArrayImgFactory();
        }
        IOFunctions.println(s + "using CellImg(256).");
        return new CellImgFactory(new int[]{256});
    }

    protected boolean fixBioformats(SpimData2 spimData, File cziFile, LightSheetZ1MetaData meta) {
        IFormatReader r = meta.getReader() == null ? LegacyLightSheetZ1ImgLoader.instantiateImageReader() : meta.getReader();
        try {
            boolean isLittleEndian = meta.isLittleEndian();
            int pixelType = meta.pixelType();
            try {
                if (meta.getReader() == null) {
                    IOFunctions.println(new Date(System.currentTimeMillis()) + ": Opening '" + cziFile.getName() + "' for reading image data.");
                    r.setId(cziFile.getAbsolutePath());
                }
            }
            catch (IllegalStateException e) {
                r.setId(cziFile.getAbsolutePath());
            }
            HashMap<Angle, ViewDescription> map = new HashMap<Angle, ViewDescription>();
            SequenceDescription sd = (SequenceDescription)spimData.getSequenceDescription();
            for (ViewSetup vs : sd.getViewSetupsOrdered()) {
                for (TimePoint t : sd.getTimePoints().getTimePointsOrdered()) {
                    ViewDescription vd = sd.getViewDescription(t.getId(), vs.getId());
                    if (!vd.isPresent()) continue;
                    map.put(((ViewSetup)vd.getViewSetup()).getAngle(), vd);
                }
            }
            for (Angle a : map.keySet()) {
                Cursor cursor;
                int z;
                ViewDescription vd = (ViewDescription)map.get(a);
                int width = (int)((ViewSetup)vd.getViewSetup()).getSize().dimension(0);
                int height = (int)((ViewSetup)vd.getViewSetup()).getSize().dimension(1);
                int depth = (int)((ViewSetup)vd.getViewSetup()).getSize().dimension(2);
                int numPx = width * height;
                r.setSeries(a.getId());
                byte[] b = new byte[numPx * meta.bytesPerPixel()];
                ArrayImg slice = ArrayImgs.floats((long[])new long[]{width, height});
                if (depth <= 0) {
                    IOFunctions.println("Size couldn't be read from metadata, trying the hard way ... this is slow as it opens everything, but might solve the problem");
                    z = 0;
                    do {
                        cursor = slice.localizingCursor();
                        try {
                            r.openBytes(r.getIndex(z, 0, vd.getTimePointId()), b);
                            if (pixelType == 1) {
                                LegacyLightSheetZ1ImgLoader.readBytesArray(b, cursor, numPx);
                            } else if (pixelType == 3) {
                                LegacyLightSheetZ1ImgLoader.readUnsignedShortsArray(b, cursor, numPx, isLittleEndian);
                            } else if (pixelType == 2) {
                                LegacyLightSheetZ1ImgLoader.readSignedShortsArray(b, cursor, numPx, isLittleEndian);
                            } else if (pixelType == 5) {
                                LegacyLightSheetZ1ImgLoader.readUnsignedIntsArray(b, cursor, numPx, isLittleEndian);
                            } else if (pixelType == 6) {
                                LegacyLightSheetZ1ImgLoader.readFloatsArray(b, cursor, numPx, isLittleEndian);
                            }
                            ++z;
                        }
                        catch (IllegalArgumentException e) {
                            ++z;
                            break;
                        }
                    } while (!LightSheetZ1.allZero((Img<FloatType>)slice));
                } else {
                    z = depth - 1;
                    for (z = depth - 1; z >= 0; --z) {
                        cursor = slice.localizingCursor();
                        r.openBytes(r.getIndex(z, 0, vd.getTimePointId()), b);
                        if (pixelType == 1) {
                            LegacyLightSheetZ1ImgLoader.readBytesArray(b, cursor, numPx);
                        } else if (pixelType == 3) {
                            LegacyLightSheetZ1ImgLoader.readUnsignedShortsArray(b, cursor, numPx, isLittleEndian);
                        } else if (pixelType == 2) {
                            LegacyLightSheetZ1ImgLoader.readSignedShortsArray(b, cursor, numPx, isLittleEndian);
                        } else if (pixelType == 5) {
                            LegacyLightSheetZ1ImgLoader.readUnsignedIntsArray(b, cursor, numPx, isLittleEndian);
                        } else if (pixelType == 6) {
                            LegacyLightSheetZ1ImgLoader.readFloatsArray(b, cursor, numPx, isLittleEndian);
                        }
                        if (!LightSheetZ1.allZero((Img<FloatType>)slice)) break;
                    }
                    ++z;
                }
                meta.imageSizes().put(a.getId(), new int[]{width, height, --z});
                for (ViewSetup vs : sd.getViewSetupsOrdered()) {
                    if (vs.getAngle().getId() != a.getId()) continue;
                    vs.setSize((Dimensions)new FinalDimensions(meta.imageSizes().get(a.getId())));
                    IOFunctions.println("Resetting image size for viewSetup: " + vs.getId() + ", old: " + width + "x" + height + "x" + depth + ", new: " + width + "x" + height + "x" + z);
                }
            }
        }
        catch (Exception e) {
            IOFunctions.println("File '" + cziFile.getAbsolutePath() + "' could not be opened: " + e);
            IOFunctions.println("Stopping");
            e.printStackTrace();
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private static final boolean allZero(Img<FloatType> slice) {
        for (FloatType t : slice) {
            if (t.get() == 0.0f) continue;
            return false;
        }
        return true;
    }

    protected boolean showDialogs(LightSheetZ1MetaData meta) {
        int i;
        int c;
        int a;
        GenericDialog gd = new GenericDialog("Lightsheet Z.1 Properties");
        gd.addMessage("Angles (" + meta.numAngles() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        for (a = 0; a < meta.numAngles(); ++a) {
            gd.addStringField("Angle_" + (a + 1) + ":", meta.angles()[a]);
        }
        gd.addMessage("Channels (" + meta.numChannels() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        for (c = 0; c < meta.numChannels(); ++c) {
            gd.addStringField("Channel_" + (c + 1) + ":", meta.channels()[c]);
        }
        gd.addMessage("Illumination Directions (" + meta.numIlluminations() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        for (i = 0; i < meta.numIlluminations(); ++i) {
            gd.addStringField("_______Illumination_" + (i + 1) + ":", meta.illuminations()[i]);
        }
        gd.addMessage("Timepoints (" + meta.numTimepoints() + " present)", new Font("SansSerif", 1, 13));
        gd.addMessage("Calibration", new Font("SansSerif", 1, 13));
        gd.addCheckbox("Modify_calibration", defaultModifyCal);
        gd.addMessage("Pixel Distance X: " + meta.calX() + " " + meta.calUnit());
        gd.addMessage("Pixel Distance Y: " + meta.calY() + " " + meta.calUnit());
        gd.addMessage("Pixel Distance Z: " + meta.calZ() + " " + meta.calUnit());
        gd.addMessage("Additional Meta Data", new Font("SansSerif", 1, 13));
        gd.addMessage("");
        gd.addCheckbox("Modify_rotation_axis", defaultRotAxis);
        gd.addCheckbox("Apply_rotation_to_dataset", defaultApplyRotAxis);
        if (meta.allImageSizesEqual()) {
            gd.addMessage("WARNING: All image stacks have the same size, this could be the Bioformats bug.", new Font("SansSerif", 1, 13), Color.red);
            defaultFixBioformats = true;
        }
        gd.addCheckbox("Fix_Bioformats image stack size bug", defaultFixBioformats);
        gd.addMessage("Acquisition Objective: " + meta.objective(), new Font("SansSerif", 2, 11));
        gd.addMessage("Rotation axis: " + meta.rotationAxisName() + " axis", new Font("SansSerif", 2, 11));
        gd.addMessage(meta.lightsheetThickness() < 0.0 ? "" : "Lighsheet thickness: " + meta.lightsheetThickness() + " um", new Font("SansSerif", 2, 11));
        gd.addMessage("Pixel type: " + meta.pixelTypeString() + " (" + meta.bytesPerPixel() + " byte per pixel)", new Font("SansSerif", 2, 11));
        IOFunctions.println("Dataset directory: " + new File(meta.files()[0]).getParent());
        IOFunctions.println("Dataset files:");
        for (i = 0; i < meta.files().length; ++i) {
            IOFunctions.println(new File(meta.files()[i]).getName());
        }
        IOFunctions.println("Image sizes:");
        for (a = 0; a < meta.numAngles(); ++a) {
            IOFunctions.println("Angle " + meta.angles()[a] + ": " + Util.printCoordinates((int[])meta.imageSizes().get(a)) + " px.");
        }
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        for (a = 0; a < meta.numAngles(); ++a) {
            meta.angles()[a] = gd.getNextString();
        }
        for (c = 0; c < meta.numChannels(); ++c) {
            meta.channels()[c] = gd.getNextString();
        }
        for (i = 0; i < meta.numIlluminations(); ++i) {
            meta.illuminations()[i] = gd.getNextString();
        }
        boolean modifyCal = defaultModifyCal = gd.getNextBoolean();
        boolean modifyAxis = defaultRotAxis = gd.getNextBoolean();
        defaultApplyRotAxis = gd.getNextBoolean();
        meta.setApplyAxis(defaultApplyRotAxis);
        this.fixBioformats = defaultFixBioformats = gd.getNextBoolean();
        if (modifyAxis || modifyCal) {
            gd = new GenericDialog("Modify Meta Data");
            if (modifyCal) {
                gd.addNumericField("Pixel_distance_x", meta.calX(), 5);
                gd.addNumericField("Pixel_distance_y", meta.calY(), 5);
                gd.addNumericField("Pixel_distance_z", meta.calZ(), 5);
                gd.addStringField("Pixel_unit", meta.calUnit());
            }
            if (modifyAxis) {
                if (meta.rotationAxis() < 0) {
                    meta.setRotationAxis(0);
                }
                gd.addChoice("Rotation_around", rotAxes, rotAxes[meta.rotationAxis()]);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            if (modifyCal) {
                meta.setCalX(gd.getNextNumber());
                meta.setCalY(gd.getNextNumber());
                meta.setCalZ(gd.getNextNumber());
                meta.setCalUnit(gd.getNextString());
            }
            if (modifyAxis) {
                meta.setRotationAxis(gd.getNextChoiceIndex());
            }
        }
        return true;
    }

    protected File queryCZIFile() {
        GenericDialogPlus gd = new GenericDialogPlus("Define Lightsheet Z.1 Dataset");
        gd.addFileField("First_CZI file of the dataset", defaultFirstFile, 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultFirstFile = gd.getNextString();
        File firstFile = new File(defaultFirstFile);
        if (!firstFile.exists()) {
            IOFunctions.println("File '" + firstFile.getAbsolutePath() + "' does not exist. Stopping");
            return null;
        }
        IOFunctions.println("Investigating file '" + firstFile.getAbsolutePath() + "'.");
        return firstFile;
    }

    @Override
    public LightSheetZ1 newInstance() {
        return new LightSheetZ1();
    }

    public static void main(String[] args) {
        defaultFirstFile = "/Users/spreibi/Downloads/007-H2B-GFP-LA-mKate2-220min-E03_E04.czi";
        new LightSheetZ1().createDataset();
    }
}

