/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.resave;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import ij.plugin.PlugIn;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.Toggle_Cluster_Options;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.resave.Generic_Resave_HDF5;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.plugin.resave.Resave_TIFF;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class Resave_HDF5
implements PlugIn {
    public static void main(String[] args) {
        new Resave_HDF5().run(null);
    }

    public void run(String arg0) {
        boolean rememberClusterProcessing = Toggle_Cluster_Options.displayClusterProcessing;
        Toggle_Cluster_Options.displayClusterProcessing = false;
        LoadParseQueryXML xml = new LoadParseQueryXML();
        if (!xml.queryXML("Resaving as HDF5", "Resave", true, true, true, true)) {
            return;
        }
        Toggle_Cluster_Options.displayClusterProcessing = rememberClusterProcessing;
        if (Resave_HDF5.loadDimensions((SpimData2)((Object)xml.getData()), xml.getViewSetupsToProcess())) {
            SpimData2.saveXML((SpimData2)((Object)xml.getData()), xml.getXMLFileName(), xml.getClusterExtension());
        }
        Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = Resave_HDF5.proposeMipmaps(xml.getViewSetupsToProcess());
        Generic_Resave_HDF5.lastExportPath = LoadParseQueryXML.defaultXMLfilename;
        int firstviewSetupId = ((ViewSetup)((SequenceDescription)((SpimData2)((Object)xml.getData())).getSequenceDescription()).getViewSetupsOrdered().get(0)).getId();
        Generic_Resave_HDF5.Parameters params = Generic_Resave_HDF5.getParameters(perSetupExportMipmapInfo.get(firstviewSetupId), true, true);
        if (params == null) {
            return;
        }
        LoadParseQueryXML.defaultXMLfilename = params.getSeqFile().toString();
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        progressWriter.out().println("starting export...");
        SpimData2 data = (SpimData2)((Object)xml.getData());
        ArrayList<ViewId> viewIds = SpimData2.getAllViewIdsSorted(data, xml.getViewSetupsToProcess(), xml.getTimePointsToProcess());
        Generic_Resave_HDF5.writeHDF5(Resave_HDF5.reduceSpimData2(data, viewIds), params, progressWriter);
        if (!params.onlyRunSingleJob || params.jobId == 0) {
            try {
                Pair<SpimData2, List<String>> result = Resave_HDF5.createXMLObject(data, viewIds, params, progressWriter, false);
                ((XmlIoSpimData2)((Object)xml.getIO())).save((SpimData2)((Object)result.getA()), params.seqFile.getAbsolutePath());
                progressWriter.setProgress(0.95);
                Resave_TIFF.copyInterestPoints(((SpimData2)((Object)xml.getData())).getBasePath(), params.getSeqFile().getParentFile(), (List)result.getB());
            }
            catch (SpimDataException e) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + params.getSeqFile() + "': " + (Object)((Object)e));
                throw new RuntimeException(e);
            }
            finally {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + params.getSeqFile() + "'.");
            }
        }
        progressWriter.setProgress(1.0);
        progressWriter.out().println("done");
    }

    public static Map<Integer, ExportMipmapInfo> proposeMipmaps(List<? extends BasicViewSetup> viewsetups) {
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        for (BasicViewSetup basicViewSetup : viewsetups) {
            perSetupExportMipmapInfo.put(basicViewSetup.getId(), ProposeMipmaps.proposeMipmaps((BasicViewSetup)basicViewSetup));
        }
        return perSetupExportMipmapInfo;
    }

    public static boolean loadDimensions(SpimData2 spimData, List<ViewSetup> viewsetups) {
        boolean loadedDimensions = false;
        block0: for (ViewSetup vs : viewsetups) {
            if (vs.getSize() != null) continue;
            IOFunctions.println("Dimensions of viewsetup " + vs.getId() + " unknown. Loading them ... ");
            for (TimePoint t : ((SequenceDescription)spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered()) {
                ViewDescription vd = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(t.getId(), vs.getId());
                if (vd.isPresent()) {
                    Dimensions dim = ((ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader()).getSetupImgLoader(vd.getViewSetupId()).getImageSize(vd.getTimePointId());
                    IOFunctions.println("Dimensions: " + dim.dimension(0) + "x" + dim.dimension(1) + "x" + dim.dimension(2) + ", loaded from tp:" + t.getId() + " vs: " + vs.getId());
                    vs.setSize(dim);
                    loadedDimensions = true;
                    continue block0;
                }
                IOFunctions.println("ViewSetup: " + vs.getId() + " not present in timepoint: " + t.getId());
            }
        }
        return loadedDimensions;
    }

    public static SpimData2 reduceSpimData2(SpimData2 oldSpimData, List<ViewId> viewIds) {
        TimePointsPattern timepoints;
        try {
            timepoints = new TimePointsPattern(Resave_TIFF.listAllTimePoints(SpimData2.getAllTimePointsSorted(oldSpimData, viewIds)));
        }
        catch (ParseException e) {
            IOFunctions.println("Automatically created list of timepoints failed to parse. This should not happen, really :) -- " + e);
            IOFunctions.println("Here is the list: " + Resave_TIFF.listAllTimePoints(SpimData2.getAllTimePointsSorted(oldSpimData, viewIds)));
            e.printStackTrace();
            return null;
        }
        ArrayList<ViewSetup> viewSetupsToProcess = SpimData2.getAllViewSetupsSorted(oldSpimData, viewIds);
        HashSet<ViewId> views = new HashSet<ViewId>();
        for (ViewId viewId : viewIds) {
            views.add(new ViewId(viewId.getTimePointId(), viewId.getViewSetupId()));
        }
        MissingViews oldMissingViews = ((SequenceDescription)oldSpimData.getSequenceDescription()).getMissingViews();
        HashSet<ViewId> missingViews = new HashSet<ViewId>();
        if (oldMissingViews != null && oldMissingViews.getMissingViews() != null) {
            for (ViewId id : oldMissingViews.getMissingViews()) {
                if (!views.contains(id)) continue;
                missingViews.add(id);
            }
        }
        for (TimePoint t : timepoints.getTimePointsOrdered()) {
            for (ViewSetup viewSetup : viewSetupsToProcess) {
                ViewId viewId = new ViewId(t.getId(), viewSetup.getId());
                if (views.contains(viewId)) continue;
                missingViews.add(viewId);
            }
        }
        SequenceDescription sequenceDescription = new SequenceDescription((TimePoints)timepoints, viewSetupsToProcess, (ImgLoader)((SequenceDescription)oldSpimData.getSequenceDescription()).getImgLoader(), new MissingViews(missingViews));
        Map oldRegMap = oldSpimData.getViewRegistrations().getViewRegistrations();
        HashMap newRegMap = new HashMap();
        for (ViewId viewId : oldRegMap.keySet()) {
            if (!views.contains(viewId)) continue;
            newRegMap.put(viewId, oldRegMap.get(viewId));
        }
        ViewRegistrations viewRegistrations = new ViewRegistrations(newRegMap);
        Map<ViewId, ViewInterestPointLists> oldInterestPoints = oldSpimData.getViewInterestPoints().getViewInterestPoints();
        HashMap<ViewId, ViewInterestPointLists> newInterestPoints = new HashMap<ViewId, ViewInterestPointLists>();
        for (ViewId viewId : oldInterestPoints.keySet()) {
            if (!views.contains(viewId)) continue;
            newInterestPoints.put(viewId, oldInterestPoints.get(viewId));
        }
        ViewInterestPoints viewsInterestPoints = new ViewInterestPoints(newInterestPoints);
        SpimData2 newSpimData = new SpimData2(oldSpimData.getBasePath(), sequenceDescription, viewRegistrations, viewsInterestPoints, oldSpimData.getBoundingBoxes());
        return newSpimData;
    }

    public static Pair<SpimData2, List<String>> createXMLObject(SpimData2 spimData, List<ViewId> viewIds, Generic_Resave_HDF5.Parameters params, ProgressWriter progressWriter, boolean useRightAway) {
        ArrayList<String> filesToCopy = new ArrayList<String>();
        SpimData2 newSpimData = Resave_TIFF.assemblePartialSpimData2(spimData, viewIds, params.seqFile.getParentFile(), filesToCopy);
        ArrayList<Partition> partitions = Generic_Resave_HDF5.getPartitions(newSpimData, params);
        Hdf5ImageLoader hdf5Loader = useRightAway ? new Hdf5ImageLoader(params.hdf5File, partitions, newSpimData.getSequenceDescription(), true) : new Hdf5ImageLoader(params.hdf5File, partitions, null, false);
        ((SequenceDescription)newSpimData.getSequenceDescription()).setImgLoader((BasicImgLoader)hdf5Loader);
        newSpimData.setBasePath(params.seqFile.getParentFile());
        return new ValuePair((Object)newSpimData, filesToCopy);
    }
}

