/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;

public abstract class AbstractSequenceDescription<V extends BasicViewSetup, D extends BasicViewDescription<V>, L extends BasicImgLoader> {
    private TimePoints timepoints;
    private Map<Integer, ? extends V> setups;
    private L imgLoader;
    private MissingViews missingViews;
    private Map<ViewId, D> viewDescriptions;
    private boolean viewDescriptionsDirty;
    private List<V> viewSetupsOrdered;
    private boolean viewSetupsOrderedDirty;

    public AbstractSequenceDescription(TimePoints timepoints, Map<Integer, ? extends V> setups, L imgLoader, MissingViews missingViews) {
        this.timepoints = timepoints;
        this.setups = setups;
        this.imgLoader = imgLoader;
        this.missingViews = missingViews;
        this.viewDescriptionsDirty = true;
        this.viewSetupsOrderedDirty = true;
    }

    public TimePoints getTimePoints() {
        return this.timepoints;
    }

    public Map<Integer, ? extends V> getViewSetups() {
        return this.setups;
    }

    public List<V> getViewSetupsOrdered() {
        if (this.viewSetupsOrderedDirty) {
            ArrayList<BasicViewSetup> list = new ArrayList<BasicViewSetup>();
            for (BasicViewSetup setup : this.setups.values()) {
                list.add(setup);
            }
            this.viewSetupsOrdered = Entity.sortById(list);
            this.viewSetupsOrderedDirty = false;
        }
        return this.viewSetupsOrdered;
    }

    public L getImgLoader() {
        return this.imgLoader;
    }

    public MissingViews getMissingViews() {
        return this.missingViews;
    }

    public Map<ViewId, D> getViewDescriptions() {
        this.createViewDescriptions();
        return this.viewDescriptions;
    }

    protected void setTimePoints(TimePoints timepoints) {
        if (timepoints != this.timepoints) {
            this.viewDescriptionsDirty = true;
        }
        this.timepoints = timepoints;
    }

    protected void setViewSetups(Map<Integer, ? extends V> setups) {
        if (setups != this.setups) {
            this.viewDescriptionsDirty = true;
            this.viewSetupsOrderedDirty = true;
        }
        this.setups = setups;
    }

    public void setImgLoader(L imgLoader) {
        this.imgLoader = imgLoader;
    }

    protected void setMissingViews(MissingViews missingViews) {
        if (missingViews != this.missingViews) {
            this.viewDescriptionsDirty = true;
        }
        this.missingViews = missingViews;
    }

    protected void createViewDescriptions() {
        if (this.viewDescriptionsDirty) {
            this.viewDescriptionsDirty = false;
            this.viewDescriptions = new HashMap<ViewId, D>();
            for (TimePoint t : this.timepoints.getTimePoints().values()) {
                for (BasicViewSetup s : this.setups.values()) {
                    D d = this.createViewDescription(t.getId(), s.getId());
                    this.viewDescriptions.put((ViewId)d, d);
                }
            }
            if (this.missingViews != null) {
                BasicViewDescription.markMissingViews(this.viewDescriptions, this.missingViews);
            }
        }
    }

    protected abstract D createViewDescription(int var1, int var2);

    protected AbstractSequenceDescription() {
    }
}

