/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import levelsets.algorithm.DeferredArray3D;

public class DeferredByteArray3D
extends DeferredArray3D {
    private final byte defaultval;

    public DeferredByteArray3D(int xdim, int ydim, int zdim, int tilesize, byte defaultval) {
        super(xdim, ydim, zdim, tilesize);
        this.defaultval = defaultval;
    }

    public final void set(int x, int y, int z, byte value) {
        byte[][][] tile = (byte[][][])this.getTile(x, y, z, true);
        tile[x % this.tilesize][y % this.tilesize][z % this.tilesize] = value;
    }

    public final byte get(int x, int y, int z) {
        byte[][][] tile = (byte[][][])this.getTile(x, y, z, false);
        if (tile == null) {
            return this.defaultval;
        }
        return tile[x % this.tilesize][y % this.tilesize][z % this.tilesize];
    }

    @Override
    public final String getAsString(int x, int y, int z) {
        return Byte.toString(this.get(x, y, z));
    }

    @Override
    protected final Object createTile(int tilesize) {
        byte[][][] tile = new byte[tilesize][tilesize][tilesize];
        if (this.defaultval != 0) {
            for (int x = 0; x < tile.length; ++x) {
                for (int y = 0; y < tile[0].length; ++y) {
                    for (int z = 0; z < tile[0][0].length; ++z) {
                        tile[x][y][z] = this.defaultval;
                    }
                }
            }
        }
        return tile;
    }
}

