/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import fiji.tool.AbstractTool;
import fiji.tool.ToolWithOptions;
import ij.IJ;
import ij.ImagePlus;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import plugin.Lasso;

public class Lasso_
extends AbstractTool
implements MouseListener,
MouseMotionListener,
ToolWithOptions {
    protected Lasso.Mode mode = Lasso.Mode.BLOW;
    protected Lasso lasso;

    public String getToolName() {
        return "Lasso/Blow Tool";
    }

    public String getToolIcon() {
        return "C000Pdaa79796a6c4c2a1613215276998a6a70";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ImagePlus image = this.getImagePlus(e);
        if (image == null) {
            return;
        }
        if (this.lasso == null || image != this.lasso.getImage()) {
            this.lasso = new Lasso(image, this.mode);
        }
        int x = this.getOffscreenX(e);
        int y = this.getOffscreenY(e);
        this.lasso.initDijkstra(x, y, IJ.shiftKeyDown());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = this.getOffscreenX(e);
        int y = this.getOffscreenY(e);
        if (this.lasso.getMode() == Lasso.Mode.BLOW) {
            this.lasso.moveBlow(x, y);
        } else {
            this.lasso.moveLasso(x, y);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void setMode(Lasso.Mode mode) {
        this.mode = mode;
        if (this.lasso != null) {
            this.lasso.setMode(mode);
        }
        IJ.showStatus((String)mode.toString());
    }

    public void setMode(String mode) {
        this.setMode(Lasso.Mode.valueOf(mode));
    }

    public void setMode(int mode) {
        this.setMode(Lasso.Mode.valueOf(mode));
    }

    public void toggleMode() {
        this.setMode((this.mode.ordinal() + 1) % Lasso.Mode.labels.length);
    }

    public void showOptionDialog() {
        if (this.lasso == null) {
            this.lasso = new Lasso(IJ.getImage());
        }
        this.lasso.optionDialog();
        this.mode = this.lasso.getMode();
    }
}

