/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import java.util.Arrays;
import java.util.Comparator;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;

public class SpearmanRankCorrelation<T extends RealType<T>>
extends Algorithm<T> {
    double rhoValue;
    double tStatisticSpearman;
    int dfSpearman;
    double[][] data;
    double[] ch1raw;
    double[] ch2raw;
    double[] ch1ranks;
    double[] ch2ranks;

    public SpearmanRankCorrelation() {
        super("Spearman's Rank Corelation calculation");
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        this.rhoValue = this.calculateSpearmanRank(cursor);
    }

    public <T extends RealType<T>> double calculateSpearmanRank(TwinCursor<T> cursor) {
        int n = 0;
        while (cursor.hasNext()) {
            ++n;
            cursor.fwd();
        }
        cursor.reset();
        this.data = new double[n][2];
        for (int i = 0; i < n; ++i) {
            cursor.fwd();
            RealType type1 = (RealType)cursor.getFirst();
            RealType type2 = (RealType)cursor.getSecond();
            this.data[i][0] = type1.getRealDouble();
            this.data[i][1] = type2.getRealDouble();
        }
        return this.calculateSpearmanRank(this.data);
    }

    public double calculateSpearmanRank(double[][] data) {
        int i;
        int n = data.length;
        this.ch1raw = new double[n];
        this.ch2raw = new double[n];
        this.ch1ranks = new double[n];
        this.ch2ranks = new double[n];
        Arrays.sort(data, new Comparator<double[]>(){

            @Override
            public int compare(double[] row1, double[] row2) {
                return Double.compare(row1[1], row2[1]);
            }
        });
        for (i = 0; i < n; ++i) {
            this.ch2raw[i] = data[i][1];
        }
        this.ch2ranks = this.rankValues(this.ch2raw);
        for (i = 0; i < n; ++i) {
            data[i][1] = this.ch2ranks[i];
        }
        Arrays.sort(data, new Comparator<double[]>(){

            @Override
            public int compare(double[] row1, double[] row2) {
                return Double.compare(row1[0], row2[0]);
            }
        });
        for (i = 0; i < n; ++i) {
            this.ch1raw[i] = data[i][0];
        }
        this.ch1ranks = this.rankValues(this.ch1raw);
        for (i = 0; i < n; ++i) {
            data[i][0] = this.ch1ranks[i];
            this.ch2ranks[i] = data[i][1];
        }
        this.rhoValue = this.calculateRho(this.ch1ranks, this.ch2ranks);
        this.tStatisticSpearman = this.getTStatistic(this.rhoValue, n);
        this.dfSpearman = this.getSpearmanDF(n);
        return this.rhoValue;
    }

    public int getSpearmanDF(int n) {
        return n - 2;
    }

    public double getTStatistic(double rho, int n) {
        double rho_squared = rho * rho;
        return rho * Math.sqrt((double)(n - 2) / (1.0 - rho_squared));
    }

    public double[] rankValues(double[] sortedVals) {
        int i;
        int len = sortedVals.length;
        int start = 0;
        int end = 0;
        double[] newranks = new double[len];
        double avg = 0.0;
        double ranksum = 0.0;
        boolean ties_found = false;
        for (i = 0; i < len; ++i) {
            newranks[i] = i + 1;
        }
        for (i = 0; i < len; ++i) {
            start = i;
            end = i;
            while (++end < len && sortedVals[start] == sortedVals[end]) {
                ties_found = true;
            }
            if (end - start != 1 && ties_found) {
                avg = 0.0;
                ranksum = 0.0;
                for (int j = start; j < end; ++j) {
                    ranksum += newranks[j];
                }
                avg = ranksum / (double)(end - start);
                for (int x = start; x < end; ++x) {
                    newranks[x] = avg;
                }
                ties_found = false;
            }
            i = end - 1;
        }
        return newranks;
    }

    public double calculateRho(double[] x, double[] y) {
        int len = x.length;
        double mean_x = 0.0;
        double mean_y = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sd_x = 0.0;
        double sd_y = 0.0;
        double sd_xy = 0.0;
        double ssd_x = 0.0;
        double ssd_y = 0.0;
        double denominator = 0.0;
        int i = 0;
        for (i = 0; i < len; ++i) {
            sum_x += x[i];
            sum_y += y[i];
        }
        mean_x = sum_x / (double)len;
        mean_y = sum_y / (double)len;
        for (i = 0; i < len; ++i) {
            sd_x = x[i] - mean_x;
            sd_y = y[i] - mean_y;
            sd_xy += sd_x * sd_y;
            ssd_x += (x[i] - mean_x) * (x[i] - mean_x);
            ssd_y += (y[i] - mean_y) * (y[i] - mean_y);
        }
        denominator = Math.sqrt(ssd_x * ssd_y);
        double rho = sd_xy / denominator;
        return rho;
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("Spearman's rank correlation value", this.rhoValue, 8);
        handler.handleValue("Spearman's correlation t-statistic", this.tStatisticSpearman, 4);
        handler.handleValue("t-statistic degrees of freedom", this.dfSpearman);
    }
}

