/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.IRUtils;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class SsaVariable
implements Variable {
    private final Variable inner;
    private final int version;

    public SsaVariable(Variable inner, int version) {
        if (inner instanceof SsaVariable) {
            throw new IllegalArgumentException("SSA variables should not be nested");
        }
        this.inner = inner;
        this.version = version;
    }

    public Variable getInner() {
        return this.inner;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        return this.inner.retrieveValue(context, temps);
    }

    @Override
    public Set<Variable> variables() {
        return Collections.singleton(this);
    }

    @Override
    public Variable replaceVariable(Variable name, Variable newName) {
        return this.equals(name) ? newName : this;
    }

    @Override
    public void setValue(Context context, Object[] temp, Object value) {
        this.inner.setValue(context, temp, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.inner.toString());
        IRUtils.appendSubscript(sb, this.version);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inner.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SsaVariable other = (SsaVariable)obj;
        return this.inner.equals(other.inner) && this.version == other.version;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitSsaVariable(this);
    }

    @Override
    public SEXP getSExpression() {
        return this.inner.getSExpression();
    }
}

