/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.internals;

import org.renjin.eval.Context;
import org.renjin.eval.Options;
import org.renjin.graphics.GraphicsDevice;
import org.renjin.graphics.GraphicsDevices;
import org.renjin.invoke.annotations.Current;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.util.CDefines;

public class Devices {
    public static GraphicsDevice GEcurrentDevice(@Current Context context) {
        if (context.getSession().getSingleton(GraphicsDevices.class).isEmpty()) {
            SEXP defdev = context.getSession().getSingleton(Options.class).get("device");
            if (CDefines.isString(defdev) && CDefines.length(defdev) > 0) {
                Symbol devName = CDefines.install(CDefines.CHAR(CDefines.STRING_ELT(defdev, 0)));
                if ((defdev = CDefines.findVar(devName, context.getGlobalEnvironment())) != CDefines.R_UnboundValue) {
                    defdev = CDefines.lang1(devName);
                    CDefines.PROTECT(defdev);
                    CDefines.eval(defdev, context, context.getGlobalEnvironment());
                    CDefines.UNPROTECT(1);
                } else {
                    Environment ns = context.getSession().getNamespaceRegistry().getNamespace(context, "grDevices").getNamespaceEnvironment();
                    if (ns != CDefines.R_UnboundValue && CDefines.findVar(devName, ns) != CDefines.R_UnboundValue) {
                        defdev = CDefines.lang1(devName);
                        CDefines.PROTECT(defdev);
                        CDefines.eval(defdev, context, ns);
                        CDefines.UNPROTECT(1);
                    } else {
                        CDefines.error(CDefines._("no active or default device"), new Object[0]);
                    }
                }
            } else if (CDefines.TYPEOF(defdev) == CDefines.CLOSXP) {
                defdev = CDefines.lang1(defdev);
                CDefines.PROTECT(defdev);
                CDefines.eval(defdev, context, context.getGlobalEnvironment());
                CDefines.UNPROTECT(1);
            } else {
                CDefines.error(CDefines._("no active or default device"), new Object[0]);
            }
        }
        return context.getSession().getSingleton(GraphicsDevices.class).getActive();
    }
}

