/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;

public class StdOutConnection
implements Connection {
    private PrintWriter stream = new PrintWriter(System.out);

    public void setOutputStream(PrintWriter out) {
        this.stream = out;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new EvalException("cannot read from stdout", new Object[0]);
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        throw new EvalException("cannot read from stdout", new Object[0]);
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this.stream;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new EvalException("Cannot open stdout for binary output, only text (todo?)", new Object[0]);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
    }

    @Override
    public String getClassName() {
        return "terminal";
    }

    @Override
    public String getDescription() {
        return "stdout";
    }

    @Override
    public String getMode() {
        return "w";
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.TEXT;
    }
}

