/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.Subscript;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;

public class PositionalSubscript
extends Subscript {
    private final int[] indices;
    private int count;

    public PositionalSubscript(AtomicVector vector2) {
        this.indices = new int[vector2.length()];
        for (int i = 0; i != this.indices.length; ++i) {
            int index = vector2.getElementAsInt(i);
            if (index == 0) continue;
            this.indices[this.count++] = IntVector.isNA(index) ? Integer.MIN_VALUE : index - 1;
        }
    }

    static boolean arePositions(AtomicVector indices) {
        boolean hasNeg = false;
        boolean hasPos = false;
        for (int i = 0; i != indices.length(); ++i) {
            int index = indices.getElementAsInt(i);
            if (index > 0 || IntVector.isNA(index)) {
                hasPos = true;
                continue;
            }
            if (index >= 0) continue;
            hasNeg = true;
        }
        if (hasNeg && hasPos) {
            throw new EvalException("only 0's may be mixed with negative subscripts", new Object[0]);
        }
        return !hasNeg;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getAt(int i) {
        return this.indices[i];
    }
}

