/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.primitives.MathExt;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.SignRank;

public class Wilcox {
    private static double[][][] w;
    private static int allocated_m;
    private static int allocated_n;
    private static final int WILCOX_MAX = 50;

    public static double rwilcox(Session context, double m, double n) {
        int i;
        if (Double.isNaN(m) || Double.isNaN(n)) {
            return m + n;
        }
        m = Math.floor(m + 0.5);
        n = Math.floor(n + 0.5);
        if (m < 0.0 || n < 0.0) {
            return Double.NaN;
        }
        if (m == 0.0 || n == 0.0) {
            return 0.0;
        }
        double r = 0.0;
        int k = (int)(m + n);
        int[] x = new int[k];
        for (i = 0; i < k; ++i) {
            x[i] = i;
        }
        i = 0;
        while ((double)i < n) {
            int j = (int)Math.floor((double)k * context.rng.unif_rand());
            r += (double)x[j];
            x[j] = x[--k];
            ++i;
        }
        x = null;
        return r - n * (n - 1.0) / 2.0;
    }

    private static void w_init_maybe(int m, int n) {
        int i;
        if (m > n) {
            i = n;
            n = m;
            m = i;
        }
        if (w != null && (m > allocated_m || n > allocated_n)) {
            w = null;
        }
        if (w == null) {
            m = Math.max(m, 50);
            n = Math.max(n, 50);
            w = new double[m + 1][][];
            for (i = 0; i <= m; ++i) {
                Wilcox.w[i] = new double[n + 1][];
            }
            allocated_m = m;
            allocated_n = n;
        }
    }

    private static double cwilcox(int k, int m, int n) {
        int j;
        int i;
        int u = m * n;
        if (k < 0 || k > u) {
            return 0.0;
        }
        int c2 = u / 2;
        if (k > c2) {
            k = u - k;
        }
        if (m < n) {
            i = m;
            j = n;
        } else {
            i = n;
            j = m;
        }
        if (j == 0) {
            return k == 0 ? 1.0 : 0.0;
        }
        if (j > 0 && k < j) {
            return Wilcox.cwilcox(k, i, k);
        }
        if (w[i][j] == null) {
            Wilcox.w[i][j] = new double[c2 + 1];
            for (int l = 0; l <= c2; ++l) {
                Wilcox.w[i][j][l] = -1.0;
            }
        }
        if (w[i][j][k] < 0.0) {
            Wilcox.w[i][j][k] = j == 0 ? (double)(k == 0 ? 1 : 0) : Wilcox.cwilcox(k - j, i - 1, j) + Wilcox.cwilcox(k, i, j - 1);
        }
        return w[i][j][k];
    }

    public static double dwilcox(double x, double m, double n, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(n)) {
            return x + m + n;
        }
        m = Math.floor(m + 0.5);
        n = Math.floor(n + 0.5);
        if (m <= 0.0 || n <= 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return SignRank.R_D__0(true, give_log);
        }
        if ((x = Math.floor(x + 0.5)) < 0.0 || x > m * n) {
            return SignRank.R_D__0(true, give_log);
        }
        Wilcox.w_init_maybe((int)m, (int)n);
        double d = give_log ? Math.log(Wilcox.cwilcox((int)x, (int)m, (int)n)) - MathExt.lchoose(m + n, (int)n) : Wilcox.cwilcox((int)x, (int)m, (int)n) / MathExt.choose(m + n, (int)n);
        return d;
    }

    public static double pwilcox(double q, double m, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(q) || Double.isNaN(m) || Double.isNaN(n)) {
            return q + m + n;
        }
        if (Double.isInfinite(m) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        m = Math.floor(m + 0.5);
        n = Math.floor(n + 0.5);
        if (m <= 0.0 || n <= 0.0) {
            return Double.NaN;
        }
        if ((q = Math.floor(q + 1.0E-7)) < 0.0) {
            return SignRank.R_DT_0(lower_tail, log_p);
        }
        if (q >= m * n) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        Wilcox.w_init_maybe((int)m, (int)n);
        double c2 = MathExt.choose(m + n, (int)n);
        double p = 0.0;
        if (q <= m * n / 2.0) {
            int i = 0;
            while ((double)i <= q) {
                p += Wilcox.cwilcox(i, (int)m, (int)n) / c2;
                ++i;
            }
        } else {
            q = m * n - q;
            int i = 0;
            while ((double)i < q) {
                p += Wilcox.cwilcox(i, (int)m, (int)n) / c2;
                ++i;
            }
            lower_tail = !lower_tail;
        }
        return SignRank.R_DT_val(p, lower_tail, log_p);
    }

    public static double qwilcox(double x, double m, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(n)) {
            return x + m + n;
        }
        if (Double.isInfinite(x) || Double.isInfinite(m) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        if (log_p && x > 0.0 || !log_p && (x < 0.0 || x > 1.0)) {
            return Double.NaN;
        }
        m = Math.floor(m + 0.5);
        n = Math.floor(n + 0.5);
        if (m <= 0.0 || n <= 0.0) {
            return Double.NaN;
        }
        if (x == SignRank.R_DT_0(lower_tail, log_p)) {
            return 0.0;
        }
        if (x == SignRank.R_DT_1(lower_tail, log_p)) {
            return m * n;
        }
        if (log_p || !lower_tail) {
            x = Normal.R_DT_qIv(x, log_p ? 1.0 : 0.0, lower_tail ? 1.0 : 0.0);
        }
        Wilcox.w_init_maybe((int)m, (int)n);
        double c2 = MathExt.choose(m + n, (int)n);
        double p = 0.0;
        double q = 0.0;
        if (x <= 0.5) {
            x -= 10.0 * SignRank.DBL_EPSILON;
            while (!((p += Wilcox.cwilcox((int)q, (int)m, (int)n) / c2) >= x)) {
                q += 1.0;
            }
        } else {
            x = 1.0 - x + 10.0 * SignRank.DBL_EPSILON;
            while (true) {
                if ((p += Wilcox.cwilcox((int)q, (int)m, (int)n) / c2) > x) {
                    q = m * n - q;
                    break;
                }
                q += 1.0;
            }
        }
        return q;
    }
}

