/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

import org.renjin.eval.Context;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.optimize.Uncmin;
import org.renjin.stats.internals.optimize.UncminFunction;

class RUncminFunction
implements UncminFunction {
    public static final Symbol GRADIENT = Symbol.get("gradient");
    public static final Symbol HESSIAN = Symbol.get("hessian");
    private final Context context;
    private Environment rho;
    private Function function;
    private boolean have_gradient;
    private boolean have_hessian;

    public RUncminFunction(Context context, Environment rho, Function fn) {
        this.context = context;
        this.rho = rho;
        this.function = fn;
    }

    public void setHaveGradient(boolean b) {
        this.have_gradient = b;
    }

    public void setHaveHessian(boolean b) {
        this.have_gradient = b;
    }

    public SEXP doApply(double[] x) {
        FunctionCall call2 = FunctionCall.newCall(this.function, new DoubleArrayVector(x));
        return this.context.evaluate(call2, this.rho);
    }

    @Override
    public double apply(double[] x) {
        AtomicVector y = (AtomicVector)this.doApply(Uncmin.from_f77(x));
        return y.getElementAsDouble(0);
    }

    @Override
    public void applyGradient(double[] x, double[] g) {
        SEXP y = this.doApply(Uncmin.from_f77(x));
        Vector gradient = (Vector)y.getAttribute(GRADIENT);
        for (int i = 0; i != gradient.length(); ++i) {
            g[i + 1] = gradient.getElementAsDouble(i);
        }
    }

    @Override
    public void applyHessian(double[] x, double[][] h) {
        throw new UnsupportedOperationException("hessian functions not yet implemented");
    }
}

