/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.cellCounter;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sc.fiji.cellCounter.CellCntrMarker;
import sc.fiji.cellCounter.CellCntrMarkerVector;

public class ReadXML {
    private boolean verbose;
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;
    private Document doc;
    private String str;
    public static final int IMAGE_FILE_PATH = 0;
    public static final int CURRENT_TYPE = 1;

    public ReadXML(String XMLFilePath) {
        this.setVerbose(this.verbose);
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
            this.doc = this.db.parse(new File(XMLFilePath));
            this.doc.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
            System.out.println(XMLFilePath + " is not well-formed.");
        }
        catch (IOException e) {
            System.out.println("IOException " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException " + e.getMessage());
        }
    }

    public String readImgProperties(int valueID) {
        switch (valueID) {
            case 0: {
                this.str = this.readSingleValue(this.doc, "Image_Filename");
                break;
            }
            case 1: {
                this.str = this.readSingleValue(this.doc, "Current_Type");
            }
        }
        if (this.str != null) {
            return this.str;
        }
        return null;
    }

    public Vector<CellCntrMarkerVector> readMarkerData() {
        Vector<CellCntrMarkerVector> typeVector = new Vector<CellCntrMarkerVector>();
        String markerName = "";
        NodeList markerTypeNodeList = this.getNodeListFromTag(this.doc, "Marker_Type");
        for (int i = 0; i < markerTypeNodeList.getLength(); ++i) {
            Element markerTypeElement = this.getElement(markerTypeNodeList, i);
            NodeList typeNodeList = markerTypeElement.getElementsByTagName("Type");
            NodeList nameNodeList = markerTypeElement.getElementsByTagName("Name");
            markerName = "Type " + Integer.parseInt(this.readValue(typeNodeList, 0));
            if (nameNodeList.getLength() > 0) {
                markerName = this.readValue(nameNodeList, 0);
            }
            CellCntrMarkerVector markerVector = new CellCntrMarkerVector(Integer.parseInt(this.readValue(typeNodeList, 0)), markerName);
            NodeList markerNodeList = markerTypeElement.getElementsByTagName("Marker");
            for (int j = 0; j < markerNodeList.getLength(); ++j) {
                Element markerElement = this.getElement(markerNodeList, j);
                NodeList markerXNodeList = markerElement.getElementsByTagName("MarkerX");
                NodeList markerYNodeList = markerElement.getElementsByTagName("MarkerY");
                NodeList markerZNodeList = markerElement.getElementsByTagName("MarkerZ");
                CellCntrMarker marker = new CellCntrMarker();
                marker.setX(Integer.parseInt(this.readValue(markerXNodeList, 0)));
                marker.setY(Integer.parseInt(this.readValue(markerYNodeList, 0)));
                marker.setZ(Integer.parseInt(this.readValue(markerZNodeList, 0)));
                markerVector.add(marker);
            }
            typeVector.add(markerVector);
        }
        return typeVector;
    }

    private String readValue(NodeList nodeList, int index) throws NullPointerException {
        Element element = this.getElement(nodeList, index);
        this.debugReport("Element = " + element.getNodeName());
        NodeList elementNodeList = this.getChildNodes(element);
        String str = this.getValue(elementNodeList, 0);
        return str;
    }

    private String readSingleValue(Document doc, String elementName) {
        NodeList nodeList = this.getNodeListFromTag(doc, elementName);
        Element element = this.getElement(nodeList, 0);
        nodeList = this.getChildNodes(element);
        String str = this.getValue(nodeList, 0);
        return str;
    }

    private NodeList getNodeListFromTag(Document doc, String elementName) {
        NodeList nodeList = doc.getElementsByTagName(elementName);
        return nodeList;
    }

    private NodeList getChildNodes(Element element) {
        NodeList nodeList = element.getChildNodes();
        return nodeList;
    }

    private Element getElement(NodeList nodeList, int index) {
        Element element = (Element)nodeList.item(index);
        return element;
    }

    private String getValue(NodeList nodeList, int index) {
        String str = nodeList.item(index).getNodeValue().trim();
        return str;
    }

    public void debugReport(String report) {
        if (this.verbose) {
            System.out.println(report);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

