/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JTextArea;
import org.scijava.log.LogService;
import org.scijava.ui.swing.script.ErrorHandler;
import org.scijava.ui.swing.script.TextEditor;

public class ExceptionHandler {
    private static ExceptionHandler instance;
    private final LogService log;
    private final Map<ThreadGroup, TextEditor> threadMap;

    private ExceptionHandler(LogService logService) {
        this.log = logService;
        this.threadMap = new WeakHashMap<ThreadGroup, TextEditor>();
    }

    public static ExceptionHandler getInstance(LogService logService) {
        if (instance == null) {
            instance = new ExceptionHandler(logService);
        } else if (ExceptionHandler.instance.log != logService) {
            throw new RuntimeException("Cannot have an ExceptionHandler with two different LogServices");
        }
        return instance;
    }

    public static void addThread(Thread thread, TextEditor editor) {
        ExceptionHandler.addThreadGroup(thread.getThreadGroup(), editor);
    }

    public static void addThreadGroup(ThreadGroup group, TextEditor editor) {
        ExceptionHandler handler = ExceptionHandler.getInstance(editor.log());
        handler.threadMap.put(group, editor);
    }

    public void handle(Throwable t) {
        for (ThreadGroup group = Thread.currentThread().getThreadGroup(); group != null; group = group.getParent()) {
            TextEditor editor = this.threadMap.get(group);
            if (editor == null) continue;
            ExceptionHandler.handle(t, editor);
            return;
        }
        this.log.error(t);
    }

    public static void handle(Throwable t, TextEditor editor) {
        JTextArea screen = editor.getErrorScreen();
        editor.getTab().showErrors();
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        StackTraceElement[] trace = t.getStackTrace();
        screen.insert(t.getClass().getName() + ": " + t.getMessage() + "\n", screen.getDocument().getLength());
        ErrorHandler handler = new ErrorHandler(screen);
        for (int i = 0; i < trace.length; ++i) {
            String fileName = trace[i].getFileName();
            int line = trace[i].getLineNumber();
            String text = "\t at " + trace[i].getClassName() + "." + trace[i].getMethodName() + "(" + fileName + ":" + line + ")\n";
            File file = editor.getFileForBasename(fileName);
            handler.addError(file == null ? null : file.getAbsolutePath(), line, text);
        }
        editor.setErrorHandler(handler);
    }
}

